#ifndef dict_h
#define dict_h

#include <memory.h>
#include <string.h>

// there are 26 letters in the English alphabet
const unsigned NUM_LETTERS=26;


// class holding the dictionary and performing queries to it
class Dictionary{
protected:
	// a trie node
	struct Dictionary_node{
		Dictionary_node* sons[NUM_LETTERS];
		bool full_word;
		
		Dictionary_node(){
			memset(sons,0,sizeof(Dictionary_node*)*NUM_LETTERS);
			full_word=false;
		}
		
		~Dictionary_node(){
			for(unsigned i=0;i<NUM_LETTERS;i++) delete sons[i];
		}
	} *root;

	// auxiliary variables for find_word function
	unsigned num_found_words; // number of found words
	Dictionary_node** found_words; // array of pointers to the final nodes in the trie

public:
	typedef void Thook_function(char* w,unsigned len);
	
	Dictionary(){
		root=new Dictionary_node();
		num_found_words=0;
		// the constant should be larger than the number of words in the dictionary
		found_words=new Dictionary_node*[1000];

	}

	~Dictionary(){
		delete root;
		delete found_words;
	}

	// inserts a word into the dictionary
	void insert_word(char* w){
		Dictionary_node* ptr=root;
		for(;*w;w++){
			if('a'<=*w && *w<='z'){
				if(!ptr->sons[*w-'a']){
					ptr->sons[*w-'a']=new Dictionary_node();
				}
				ptr=ptr->sons[*w-'a'];
			}
			else{
				fprintf(stderr,"\nError: invalid character in the dictionary: %c",*w);
				exit(2);
			}
		}
		ptr->full_word=true;
	}

	// calls the given hook-function for all found words;
	// info is an additional information passed to f,
	// e.g. the `this' pointer
	void find_words(char* w, Thook_function f){
		Dictionary_node* ptr;
		unsigned depth;

		// try to find words starting from each position
		for(;*w;w++){
			ptr=root;
			depth=0;

			// find all words starting from position pos
			for(;w[depth] && ptr->sons[w[depth]-'a'];depth++){
				ptr=ptr->sons[w[depth]-'a'];
				if(ptr->full_word){
					// a new word is found

					// add ptr to the array of found words
					found_words[num_found_words++]=ptr;

					// ammend the current node of the trie so that 
					// this word is not found again
					ptr->full_word=false;

					// call the hook function;
					f(w,depth+1);
				}
			}
		}

		// restore the ammended nodes of the trie
		while(num_found_words){
			found_words[--num_found_words]->full_word=true;
		}
	}
};

#endif
