// test of a genetic algorithm

#include <stdlib.h>
#include <stdio.h>
#include <time.h>

#include "dict.h"
#include "ga.h"


// **************** RICHARD DAWKINS' METHOD ****************************

const char* weasel_phrase="methinksitislikeaweasel";

// computes an individual's score
void compute_score1(Individual* ind){
	unsigned score=0;
	for(const char *str1=weasel_phrase,*str2=ind->str;*str1;str1++,str2++){
		if(*str1==*str2) score++;
	}
	ind->score=score;
}

char upcase(char c){
	return c-'a'+'A';
}

void print1(Individual* ind){
	for(const char *str1=weasel_phrase,*str2=ind->str;*str1;str1++,str2++){
		printf("%c", *str1==*str2 ? upcase(*str2) : *str2);
	}
	printf(", number=%d",ind->number);
}

// *********************************************************************


// **************** METHOD WITH COARSER ACKNOWLEDGEMENTS ***************

Dictionary* dictionary=0;
unsigned buf_score=0;

void add_score(char* w,unsigned len){
	buf_score+=len;
}

// computes the score of a string
void compute_score2(Individual* ind){
	buf_score=0;
	dictionary->find_words(ind->str,add_score);
	ind->score=buf_score;
}

void print_word(char* w,unsigned len){
	putchar(' ');
	for(;len;w++,len--) putchar(*w);
}

void print2(Individual* ind){
	printf("%s, number=%d",ind->str,ind->number);
	printf("\nwords:");
	dictionary->find_words(ind->str,print_word);
}

// *********************************************************************


void run_GA(Population* p, unsigned num_gen){
	p->steps(num_gen);
	if(p->best_individual->score!=p->max_score) p->print_statistics();
}

void print_usage(){
	fprintf(stderr,
		"\n  Usage:"
		"\n    gen [options]"
		"\n  Options:"
		"\n    -Gn		stop after n generations (n is a positive integer)"
		"\n    -Sn		specify the population size (n is a positive integer)"
		"\n    -Rn		set the seed for pseudo-random numbers generator (the current time is used if not set)"
	);
}


int main(int argc, char** argv){
	unsigned num_gen=1000000;
	unsigned population_size=100;
	unsigned seed=(unsigned)time(0);

	// parse the command line parameters
	for(;argc>1;argc--,argv++){
		if(argv[1][0]!='-'){
			fprintf(stderr, "\nError: unrecognized option: %s",argv[1]);
			print_usage();
			return 2;
		}

		switch(argv[1][1]){
		case 'G':
		case 'g':
			num_gen=atoi(argv[1]+2);
			break;
		case 'S':
		case 's':
			population_size=atoi(argv[1]+2);
			break;
		case 'R':
		case 'r':
			seed=atoi(argv[1]+2);
			break;
		default:
			fprintf(stderr, "\nError: unrecognized option: %s",argv[1]);
			print_usage();
			return 2;
		}
	}

	printf("Parameters of the algorithm:"
		"\n\tPopulation size: %d"
		"\n\tSeed for pseude-random number generator: %d",
		population_size,
		seed
	);

	// set the seed
	srand(seed);

	Population* population;

	printf("\n\nThe original R. Dawkins' model (maximum reachable fitness is 23):");
	population=new Population(population_size,compute_score1,print1,23);
	run_GA(population,num_gen);
	delete population;

	dictionary=new Dictionary();
	// 1-word sequences
	dictionary->insert_word("methinks");
	dictionary->insert_word("it");
	dictionary->insert_word("is");
	dictionary->insert_word("like");
	dictionary->insert_word("a");
	dictionary->insert_word("weasel");
	// 2-word sequences
	dictionary->insert_word("methinksit");
	dictionary->insert_word("itis");
	dictionary->insert_word("islike");
	dictionary->insert_word("likea");
	dictionary->insert_word("aweasel");
	// 3-word sequences
	dictionary->insert_word("methinksitis");
	dictionary->insert_word("itislike");
	dictionary->insert_word("islikea");
	dictionary->insert_word("likeaweasel");
	// 4-word sequences
	dictionary->insert_word("methinksitislike");
	dictionary->insert_word("itislikea");
	dictionary->insert_word("islikeaweasel");
	// 5-word sequences
	dictionary->insert_word("methinksitislikea");
	dictionary->insert_word("itislikeaweasel");
	// 6-word sequences
	dictionary->insert_word("methinksitislikeaweasel");

	printf("\n\nThe model with coarse acknowledgements (maximum reachable fitness is 186):");
	population=new Population(population_size,compute_score2,print2,186);
	run_GA(population,num_gen);
	delete population;

	delete dictionary;

	return 0;
}

