#ifndef __OBJECTIVE_H_
#define __OBJECTIVE_H_

#include "global.h"

#define PI   3.141592653589793238462643383279502884197169399375105
#define SQR2  sqrt(2)

void objectives(vector<double> x_var, vector <double> &y_obj)
{
	if (!strcmp(strTestInstance, "F1"))
	{
		double g = 0, t;
		for (int n = 1; n<numVariables; n++)
		{
			t = x_var[n] - sin(0.5*PI*x_var[n]);
			g += 1 + t*t - cos(2 * PI*t);

		}
		g = 1 + 2 * sin(PI*x_var[0])*g;
		y_obj[0] = g*(x_var[0]);
		y_obj[1] = g*pow(1 - pow(x_var[0], 0.5), 3);

	}

	if (!strcmp(strTestInstance, "F2"))
	{
		double g = 0, t;
		for (int n = 1; n<numVariables; n++)
		{
			t = x_var[n] - sin(0.5*PI*x_var[n]);
			g += 1 + t*t - cos(2 * PI*t);

		}
		g = 1 + 2 * sin(PI*x_var[0])*g;
		y_obj[0] = g*(x_var[0]);
		y_obj[1] = g*pow(1 - pow(x_var[0], 5), 0.5);

	}

	if (!strcmp(strTestInstance, "F3"))
	{
		double g = 0, t;
		for (int n = 1; n<numVariables; n++)
		{
			t = x_var[n] - sin(0.5*PI*x_var[n]);
			g += 1 + t*t - cos(2 * PI*t);

			//g+= x_var[n];
		}
		//g = 1 + 9*g/(numVariables-1);
		g = 1 + 2 * sin(PI*x_var[0])*g;
		y_obj[0] = g*(x_var[0]);
		//y_obj[1] = g*(1 - pow(y_obj[0]/g,5));
		//y_obj[1] = g*exp(-5.0*x_var[0])*(1-pow(x_var[0],0.2));
		//y_obj[1] = g*pow(1-pow(x_var[0],0.5),5);
		//y_obj[1] = g*(1-pow(x_var[0],0.5)*pow(cos(2*PI*x_var[0]),2));
		//y_obj[1] = 0.5*g*(x_var[0]+pow(x_var[0],0.5)*pow(cos(4*PI*x_var[0]),2));
		y_obj[1] = 0.5*g*(1 - pow(x_var[0], 0.1) + pow(1 - pow(x_var[0], 0.5), 2)*pow(cos(3 * PI*x_var[0]), 2));
	}

	if (!strcmp(strTestInstance, "F4"))
	{
		double g = 0, t;
		for (int n = 1; n<numVariables; n++)
		{
			t = x_var[n] - sin(0.5*PI*x_var[n]);
			g += 1 + t*t - cos(2 * PI*t);
		}
		g = 1 + 2 * sin(PI*x_var[0])*g;
		y_obj[0] = g*pow((x_var[0] + 0.05*sin(6 * PI*x_var[0])), 2.0);
		y_obj[1] = g*pow((1 - x_var[0] + 0.05*sin(6 * PI*x_var[0])), 2.0);
	}

	if (!strcmp(strTestInstance, "F5"))
	{
		double g = 0, t;
		for (int n = 1; n<numVariables; n++)
		{
			t = x_var[n] - sin(0.5*PI*x_var[n]);
			g += 1 + t*t - cos(2 * PI*t);
		}
		g = 1 + 2 * sin(PI*x_var[0])*g;
		y_obj[0] = g*pow((x_var[0] + 0.05*sin(6 * PI*x_var[0])), 0.2);
		y_obj[1] = g*pow((1 - x_var[0] + 0.05*sin(6 * PI*x_var[0])), 10);
	}

	if (!strcmp(strTestInstance, "F6"))
	{
		double g = 0, prod;

		for (int n = numObjectives - 1; n<numVariables; n++)
		{
			double x = (x_var[n] - 0.5);
			g = g + x*x;
		}
		g = 1.0 + g;
		prod = g;
		for (int n = 0; n<numObjectives - 1; n++)
			prod *= cos(0.5*PI*x_var[n]);
		y_obj[0] = prod;

		for (int i = 1; i<numObjectives; i++)
		{
			prod = g;
			for (int j = 0; j<numObjectives - 1 - i; j++)
				prod *= cos(0.5*PI*x_var[j]);
			prod *= sin(0.5*PI*x_var[numObjectives - 1 - i]);
			y_obj[i] = prod;
		}
		y_obj[0] = pow(y_obj[0], 4.0);
		y_obj[1] = pow(y_obj[1], 4.0);
		y_obj[2] = pow(y_obj[2], 2.0);
	}

	if(!strcmp(strTestInstance,"ZDT1"))
	{
		double g = 0;
		
		for(int n=1;n<numVariables;n++)
			g+= x_var[n];
		g = 1 + 9*g/(numVariables-1);
		
		//for(int n=1;n<numVariables;n++)
		//{
		//	g+=pow((pow(x_var[n],2)-x_var[n-1]),2);
		//	//g+=pow((pow(x_var[n-1],2)-x_var[n]),2);
		//}

		//g = 1 + pow(g,0.0001);

		y_obj[0] = x_var[0];
		//y_obj[1] = g*(1 - sqrt(y_obj[0]/g));
		y_obj[1]=2*pow(g/(1+y_obj[0]),1/g)-0.5;
		return;
	}


	if(!strcmp(strTestInstance,"ZDT2"))
	{
		double g = 0;
		for(int n=1;n<numVariables;n++)
			g+= x_var[n];
		g = 1 + 9*g/(numVariables-1);
		y_obj[0] = x_var[0];
		y_obj[1] = g*(1 - pow(y_obj[0]/g,2));
	}


	
	if(!strcmp(strTestInstance,"ZDT3"))
	{
		double g = 0;
		for(int n=1;n<numVariables;n++)
			g+= x_var[n];
		g = 1 + 9*g/(numVariables-1);

		y_obj[0] = x_var[0];
		y_obj[1] = g*(1 - sqrt(x_var[0]/g) - x_var[0]*sin(10*PI*x_var[0])/g);
	}


	if(!strcmp(strTestInstance,"ZDT4"))
	{
		double g = 0;
		for(int n=1;n<numVariables;n++)
		{
			double x = 10*(x_var[n] - 0.5);
			g+= x*x - 10*cos(4*PI*x);
		}
		g = 1 + 10*(numVariables-1) + g;
		y_obj[0] = x_var[0];
		y_obj[1] = g*(1- sqrt(y_obj[0]/g));
	}

	if(!strcmp(strTestInstance,"ZDT6"))
	{
		double g = 0;
		for(int n=1;n<numVariables;n++)
			g+= x_var[n]/(numVariables - 1);
		g = 1 + 9*pow(g,0.25) ;

		y_obj[0] = 1 - exp(-4*x_var[0])*pow(sin(6*PI*x_var[0]),6);
		y_obj[1] = g*(1- pow(y_obj[0]/g,2));
	}

	// OKA 1
	if(!strcmp(strTestInstance,"OKA-1"))
	{
		double x1 = 2*PI*(x_var[0] - 0.5);
		double x2 = (x_var[1] - 0.5)*10;
		y_obj[0] = x1;
		y_obj[1] = PI - x1 + fabs(x2 - 5*cos(x1));
	}

	if(!strcmp(strTestInstance,"OKA-2"))
	{
		double x1 = 2*pow(PI,3)*(x_var[0] - 0.5);
		double x2 = (x_var[1] - 0.5)*10;
		double eta;
		if(x1>=0) eta = pow(x1,1.0/3);
		else      eta = -pow(-x1,1.0/3);

		y_obj[0] = eta;
		y_obj[1] = PI - eta + fabs(x2 - 5*cos(x1));
	}

	if(!strcmp(strTestInstance,"DTLZ1"))
	{
		double g = 0, prod;
		for (int n = numObjectives - 1; n < numVariables; n++)
		{
			g = g +1+ pow(x_var[n] - 0.5, 2) - cos(20 * PI*(x_var[n] - 0.5));
		}
		g =1.0+100*g;

		prod=g;
		for (int n=0; n<numObjectives-1; n++)
			prod*=x_var[n];
		y_obj[0]=0.5*prod;

		for (int i=1; i<numObjectives; i++)
		{
			prod=g;
			for (int j=0; j<numObjectives-1-i; j++)
				prod*=x_var[j];
			prod*=(1.0-x_var[numObjectives-1-i]);
			y_obj[i]=0.5*prod;
		}
	}

	if(!strcmp(strTestInstance,"DTLZ2"))
	{
		double g = 0, prod;
		
		for(int n=numObjectives-1; n<numVariables;n++)				
		{
			double x = (x_var[n] - 0.5);
			g = g + x*x;
		}
		g=1.0+g;
		prod=g;
		for (int n=0; n<numObjectives-1; n++)
			prod*=cos(0.5*PI*x_var[n]);
		y_obj[0]=prod;

		for (int i=1; i<numObjectives; i++)
		{
			prod=g;
			for (int j=0; j<numObjectives-1-i; j++)
				prod*=cos(0.5*PI*x_var[j]);
			prod*=sin(0.5*PI*x_var[numObjectives-1-i]);
			y_obj[i]=prod;
		}
	}

	if(!strcmp(strTestInstance,"DTLZ3"))
	{
		double g = 0, prod;
		
		for(int n=numObjectives-1; n<numVariables;n++)				
		{
			double x = (x_var[n] - 0.5);
			g = g + x*x-cos(20*PI*x);
		}
		g=1.0+(g+numVariables-numObjectives+1);
		prod=g;
		for (int n=0; n<numObjectives-1; n++)
			prod*=cos(0.5*PI*x_var[n]);
		y_obj[0]=prod;

		for (int i=1; i<numObjectives; i++)
		{
			prod=g;
			for (int j=0; j<numObjectives-1-i; j++)
				prod*=cos(0.5*PI*x_var[j]);
			prod*=sin(0.5*PI*x_var[numObjectives-1-i]);
			y_obj[i]=prod;
		}
	}

   if(!strcmp(strTestInstance,"DTLZ4"))
	{
		double g = 0, prod;
		
		for(int n=numObjectives-1; n<numVariables;n++)				
		{
			double x = (x_var[n] - 0.5);
			g = g + x*x;;
		}

		
		g=1.0+g;
		prod=g;
		for (int n=0; n<numObjectives-1; n++)
		{
			prod*=cos(0.5*PI*pow(x_var[n], 100.0));
		}
		y_obj[0]=prod;

		for (int i=1; i<numObjectives; i++)
		{
			prod=g;
			for (int j=0; j<numObjectives-1-i; j++)
				prod*=cos(0.5*PI*pow(x_var[j],100.0));
			prod*=sin(0.5*PI*pow(x_var[numObjectives-1-i],100.0));
			y_obj[i]=prod;
		}
	}

   //******************MOP Test Suite**********************//
   //MOP1-5 are biobjective, MOP6-7 triobjective, # variables=10//

   // MOP1
   if (!strcmp(strTestInstance, "MOP1"))
   {
	   double sum = 0, g = 0, t;
	   int i;
	   for (i = 1; i < numVariables; i++)
	   {
		   t = x_var[i] - sin(0.5*PI*x_var[0]);
		   sum += -0.9*t*t + pow(fabs(t), 0.6);
		   //sum += sin(1.4*PI*pow(fabs(t),0.5))+ pow(fabs(t), 0.5);
	   }
	   //g = 1 + 2 * sin(PI*x_var[0])*sum;
	   g = 1 + 2 *fabs(sin(2*PI*x_var[0]))*sum;
	   y_obj[0] = g*x_var[0];
	   y_obj[1] = g*(1 - pow(x_var[0], 0.5));
   }

   // MOP2
   if (!strcmp(strTestInstance, "MOP2"))
   {
	   double sum = 0, g = 0, t;
	   int i;
	   for (i = 1; i < numVariables; i++)
	   {
		   t = x_var[i] - sin(0.5*PI*x_var[0]);
		   sum += fabs(t) / (1 + exp(5.0*fabs(t)));
	   }
	   g = 1 + 10 * sin(PI*x_var[0])*sum;
	   y_obj[0] = g*x_var[0];
	   y_obj[1] = g*(1 - pow(x_var[0], 2.0));
   }

   // MOP3
   if (!strcmp(strTestInstance, "MOP3"))
   {
	   double sum = 0, g = 0, t;
	   int i;
	   for (i = 1; i < numVariables; i++)
	   {
		   t = x_var[i] - sin(0.5*PI*x_var[0]);
		   sum += fabs(t) / (1 + exp(5.0*fabs(t)));
	   }
	   g = 1 + 10 * sin(0.5*PI*x_var[0])*sum;
	   y_obj[0] = g*cos(0.5*PI*x_var[0]);
	   y_obj[1] = g*sin(0.5*PI*x_var[0]);
   }

   // MOP4
   if (!strcmp(strTestInstance, "MOP4"))
   {
	   double sum = 0, g = 0, t;
	   int i;
	   for (i = 1; i < numVariables; i++)
	   {
		   t = x_var[i] - sin(0.5*PI*x_var[0]);
		   sum += fabs(t) / (1 + exp(5.0*fabs(t)));
	   }
	   g = 1 + 10 * sin(PI*x_var[0])*sum;
	   y_obj[0] = g*x_var[0];
	   y_obj[1] = g*(1 - pow(x_var[0], 0.5)*pow(cos(2.0*PI*x_var[0]), 2.0));
   }

   // MOP5
   if (!strcmp(strTestInstance, "MOP5"))
   {
	   double sum = 0, g = 0, t;
	   int i;
	   for (i = 1; i < numVariables; i++)
	   {
		   t = x_var[i] - sin(0.5*PI*x_var[0]);
		   sum += -0.9*t*t + pow(fabs(t), 0.6);
	   }
	   g = 1 + 2 * fabs(cos(PI*x_var[0]))*sum;
	   y_obj[0] = g*x_var[0];
	   y_obj[1] = g*(1 - pow(x_var[0], 0.5));
   }

   // MOP6
   if (!strcmp(strTestInstance, "MOP6"))
   {
	   double sum = 0, g = 0, t;
	   int i;
	   for (i = 2; i < numVariables; i++)
	   {
		   t = x_var[i] - x_var[0] * x_var[1];
		   sum += -0.9*t*t + pow(fabs(t), 0.6);
	   }
	   g = 1 + 2 * sin(PI*x_var[0])*sum;
	   y_obj[0] = g*x_var[0] * x_var[1];
	   y_obj[1] = g*x_var[0] * (1 - x_var[1]);
	   y_obj[2] = g*(1 - x_var[0]);
   }

   // MOP7
   if (!strcmp(strTestInstance, "MOP7"))
   {
	   double sum = 0, g = 0, t;
	   int i;
	   for (i = 2; i < numVariables; i++)
	   {
		   t = x_var[i] - x_var[0] * x_var[1];
		   sum += -0.9*t*t + pow(fabs(t), 0.6);
	   }
	   g = 1 + 2 * sin(PI*x_var[0])*sum;
	   y_obj[0] = g*cos(0.5*PI*x_var[0])*cos(0.5*PI*x_var[1]);
	   y_obj[1] = g*cos(0.5*PI*x_var[0])*sin(0.5*PI*x_var[1]);
	   y_obj[2] = g*sin(0.5*PI*x_var[0]);
   }
}


#endif