/*==========================================================================
//  eMOEA/D: enhanced MOEA/D with new scalarizing functions and population update
//  stategies (2017).
//
//  See the details of eMOEA/D in the following paper
//  Scalarizing Functions in Decomposition-based Multiobjective Evolutionary Algorithms
//
//  The source code of eMOEA/D was implemented by Shouyong Jiang based on the original 
//  MOEA/D code.  
//
//  If you have any questions about the codes, please contact 
//  Shouyong Jiang at math4neu@gmail.com
===========================================================================*/


#include "global.h"
#include "dmoea.h"
int main()
{

	// set the type of decomposition method
	// "_TCH1": Tchebycheff, "_TCH2": normalized Tchebycheff, "_PBI": Penalty-based BI
        strcpy(strFunctionType, "_MSF");  
	//strcpy(strFunctionType, "_PSF");
	//strcpy(strFunctionType, "_PBI");

	char *instances[] = { "MOP1", "MOP2", "MOP3", "MOP4", "MOP5", "MOP6", "MOP7" };
	int  nvars[]       = {10, 10, 10, 10, 10, 10, 10};                         // number of variables
	int  nobjs[]       = {2, 2, 2, 2, 2, 3, 3};                                // number of objectives

	//for (int n = 0; n <7; n++)
	{

	    int n=0;
		strcpy(strTestInstance,instances[n]);		
		numObjectives = nobjs[n];
		numVariables = 10; // 10 * (numObjectives - 1) + 10;
		
		char parName1[250];
		sprintf(parName1, "eMOEAD/%s_obj_%i", strTestInstance,numObjectives);
		if (mkdir(parName1))
			cout << "this file has already existed.\n";

		for(int run=1; run<=total_run; run++)
		{
			sprintf(fileName, "%s/run_%d", parName1, run);
			if (mkdir(fileName))
				cout << "this file has already existed.\n";

			seed = (seed + 111)%1235;	
			rnd_uni_init = -(long)seed;	
			TMOEAD  MOEAD;      
			
			if(numObjectives>2)  MOEAD.run(13, niche, max_gen, run);  //23 -3 (SLD) popsize 300|| 13-3 (klayer) 304 

			if(numObjectives==2)  MOEAD.run(99, niche, max_gen, run);  //99 -2  popsize 100

		}		
	}
    return 0;
}