#ifndef _RECOMBINATION_H_
#define _RECOMBINATION_H_

#include "global.h"

/* Routine for real variable SBX crossover */

template <class T>
void real_sbx_xover1(T parent1, T parent2, T& child)
{
	double rand;
	double y1, y2, yl, yu;
	double c1, c2;
	double alpha, beta, betaq;
	double eta_c = etax;
	if (rnd_uni(&rnd_uni_init) <= 1.0)
	{
		for (int i = 0; i<n_var; i++)
		{
			if (rnd_uni(&rnd_uni_init) <= 0.5)
			{
				if (fabs(parent1.x_var[i] - parent2.x_var[i]) > EPS)
				{
					if (parent1.x_var[i] < parent2.x_var[i])
					{
						y1 = parent1.x_var[i];
						y2 = parent2.x_var[i];
					}
					else
					{
						y1 = parent2.x_var[i];
						y2 = parent1.x_var[i];
					}
					yl = lowBound[i];
					yu = uppBound[i];
					rand = rnd_uni(&rnd_uni_init);
					beta = 1.0 + (2.0*(y1 - yl) / (y2 - y1));
					alpha = 2.0 - pow(beta, -(eta_c + 1.0));
					if (rand <= (1.0 / alpha))
					{
						betaq = pow((rand*alpha), (1.0 / (eta_c + 1.0)));
					}
					else
					{
						betaq = pow((1.0 / (2.0 - rand*alpha)), (1.0 / (eta_c + 1.0)));
					}
					c1 = 0.5*((y1 + y2) - betaq*(y2 - y1));
					beta = 1.0 + (2.0*(yu - y2) / (y2 - y1));
					alpha = 2.0 - pow(beta, -(eta_c + 1.0));
					if (rand <= (1.0 / alpha))
					{
						betaq = pow((rand*alpha), (1.0 / (eta_c + 1.0)));
					}
					else
					{
						betaq = pow((1.0 / (2.0 - rand*alpha)), (1.0 / (eta_c + 1.0)));
					}
					c2 = 0.5*((y1 + y2) + betaq*(y2 - y1));
					if (c1<yl)
						c1 = yl;
					if (c2<yl)
						c2 = yl;
					if (c1>yu)
						c1 = yu;
					if (c2>yu)
						c2 = yu;
					if (rnd_uni(&rnd_uni_init) <= 0.5)
					{
						child.x_var[i] = c2;
					}
					else
					{
						child.x_var[i] = c1;
					}
				}
				else
				{
					child.x_var[i] = parent1.x_var[i];
				}
			}
			else
			{
				child.x_var[i] = parent1.x_var[i];
			}
		}
	}
	else
	{
		for (int i = 0; i<n_var; i++)
		{
			child.x_var[i] = parent1.x_var[i];
		}
	}
	return;
}

template <class T>
void real_sbx_xover2(T parent1, T parent2, T& child1, T& child2)
{
    double rand;
    double y1, y2, yl, yu;
    double c1, c2;
    double alpha, beta, betaq;
	double eta_c = etax;
    if (rnd_uni(&rnd_uni_init) <= 1.0) 
    {
        for (int i=0; i<n_var; i++)
        {
            if (rnd_uni(&rnd_uni_init)<=0.5 )
            {
                if (fabs(parent1.x_var[i]-parent2.x_var[i]) > EPS)
                {
                    if (parent1.x_var[i] < parent2.x_var[i])
                    {
                        y1 = parent1.x_var[i];
                        y2 = parent2.x_var[i];
                    }
                    else
                    {
                        y1 = parent2.x_var[i];
                        y2 = parent1.x_var[i];
                    }
                    yl = lowBound[i];
                    yu = uppBound[i];
                    rand = rnd_uni(&rnd_uni_init);
                    beta = 1.0 + (2.0*(y1-yl)/(y2-y1));
                    alpha = 2.0 - pow(beta,-(eta_c+1.0));
                    if (rand <= (1.0/alpha))
                    {
                        betaq = pow ((rand*alpha),(1.0/(eta_c+1.0)));
                    }
                    else
                    {
                        betaq = pow ((1.0/(2.0 - rand*alpha)),(1.0/(eta_c+1.0)));
                    }
                    c1 = 0.5*((y1+y2)-betaq*(y2-y1));
                    beta = 1.0 + (2.0*(yu-y2)/(y2-y1));
                    alpha = 2.0 - pow(beta,-(eta_c+1.0));
                    if (rand <= (1.0/alpha))
                    {
                        betaq = pow ((rand*alpha),(1.0/(eta_c+1.0)));
                    }
                    else
                    {
                        betaq = pow ((1.0/(2.0 - rand*alpha)),(1.0/(eta_c+1.0)));
                    }
                    c2 = 0.5*((y1+y2)+betaq*(y2-y1));
                    if (c1<yl)
                        c1=yl;
                    if (c2<yl)
                        c2=yl;
                    if (c1>yu)
                        c1=yu;
                    if (c2>yu)
                        c2=yu;
                    if (rnd_uni(&rnd_uni_init)<=0.5)
                    {
                        child1.x_var[i] = c2;
                        child2.x_var[i] = c1;
                    }
                    else
                    {
                        child1.x_var[i] = c1;
                        child2.x_var[i] = c2;
                    }
                }
                else
                {
                    child1.x_var[i] = parent1.x_var[i];
                    child2.x_var[i] = parent2.x_var[i];
                }
            }
            else
            {
                child1.x_var[i] = parent1.x_var[i];
                child2.x_var[i] = parent2.x_var[i];
            }
        }
    }
    else
    {
        for (int i=0; i<n_var; i++)
        {
            child1.x_var[i] = parent1.x_var[i];
            child2.x_var[i] = parent2.x_var[i];
        }
    }
    return;
}


template <class T>
void diff_evo_xover1(T ind0, T ind1, T ind2, T& new_ind)
{

	int idx_rnd = int(rnd_uni(&rnd_uni_init)*n_var);

	double rate = 0.5;

	  for(int n=0;n<n_var;n++)
	  {
		  /*Selected Two Parents*/

		  new_ind.x_var[n] = ind0.x_var[n] + rate*(ind2.x_var[n] - ind1.x_var[n]);

		  /*
		  double rnd1 = rnd_uni(&rnd_uni_init);
		  if(rnd1<0.9||n==idx_rnd)
		  //if(rnd1<1.0||n==idx_rnd)
			  new_ind.x_var[n] = ind0.x_var[n] + rate*(ind2.x_var[n] - ind1.x_var[n]);
		  else
		      new_ind.x_var[n] = ind0.x_var[n];
		  //*/

		  if(new_ind.x_var[n]<lowBound[n]){
			  double rnd = rnd_uni(&rnd_uni_init);
			  new_ind.x_var[n] = lowBound[n] + rnd*(ind0.x_var[n] - lowBound[n]);
		  }
		  if(new_ind.x_var[n]>uppBound[n]){ 
			  double rnd = rnd_uni(&rnd_uni_init);
			  new_ind.x_var[n] = uppBound[n] - rnd*(uppBound[n] - ind0.x_var[n]);
		  }
	
		  //if(new_ind.x_var[n]<lowBound) new_ind.x_var[n] = lowBound;
		  //if(new_ind.x_var[n]>uppBound) new_ind.x_var[n] = uppBound;
	  }
}

template <class T>
void diff_evo_xover2(T ind0, T ind1, T ind2, T ind3, T& new_ind, double rate)
{

	// Check Whether the cross-over to be performed
	/*Loop over no of variables*/
	int idx_rnd = int(rnd_uni(&rnd_uni_init)*n_var);

	for (int n = 0; n<n_var; n++){
		/*Selected Two Parents*/

		double rnd = rnd_uni(&rnd_uni_init);
		if (rnd<1 || n == idx_rnd)
			new_ind.x_var[n] = ind1.x_var[n] + rate*(ind2.x_var[n] - ind3.x_var[n]);
		else
			new_ind.x_var[n] = ind0.x_var[n];

		if (new_ind.x_var[n]<lowBound[n]) new_ind.x_var[n] = lowBound[n];
		if (new_ind.x_var[n]>uppBound[n]) new_ind.x_var[n] = uppBound[n];
	}
}

template <class T>
void diff_evo_xover3(T ind0, T ind1, T ind2, vector<double> &xdiff,T& new_ind,  double rate)
{
      double rnd = rnd_uni(&rnd_uni_init), rnd2 = rnd_uni(&rnd_uni_init);
	  for(int n=0;n<n_var;n++)
	  {
		  /*Selected Two Parents*/
		  
		  if(rnd<1)
		      new_ind.x_var[n] = ind0.x_var[n] + rate*(ind2.x_var[n] - ind1.x_var[n]);
		  else
			  new_ind.x_var[n] = ind0.x_var[n] + rnd2*xdiff[n];
	
		  if(new_ind.x_var[n]<lowBound[n]) new_ind.x_var[n] = lowBound[n];
		  if(new_ind.x_var[n]>uppBound[n]) new_ind.x_var[n] = uppBound[n];
	  }
}

/* Routine for real variable LLcrossover */
template <class T>
void LLcrossover(T &parent1, T &parent2, T& child)
{
	int i;
	double a = pow(1.0 - 1.0*(gen-1)/ max_gen, 0.7);
	double rc = 2.0*(rnd_uni(&rnd_uni_init) - 0.5)*(1 - pow(rnd_uni(&rnd_uni_init), -a));
	for (i = 0; i<n_var; i++){
		child.x_var[i] = parent1.x_var[i] + rc*(parent1.x_var[i] - parent2.x_var[i]);
		if (child.x_var[i]<lowBound[i])
			child.x_var[i] = lowBound[i] + 0.5*rnd_uni(&rnd_uni_init)*(parent1.x_var[i] - lowBound[i]);
		if (child.x_var[i]>uppBound[i])
			child.x_var[i] = uppBound[i] - 0.5*rnd_uni(&rnd_uni_init)*(uppBound[i] - parent1.x_var[i]);
	}
}


/* Routine for real polynomial mutation of an T */
template <class T>
void realmutation(T& ind, double rate)
{
	double rnd, delta1, delta2, mut_pow, deltaq;
	double y, yl, yu, val, xy;
	double eta_m = etam;

	int    id_rnd = int(rnd_uni(&rnd_uni_init)*n_var);

	for (int j = 0; j<n_var; j++)
	{
		if (rnd_uni(&rnd_uni_init) <= rate)
		{
			y = ind.x_var[j];
			yl = lowBound[j];
			yu = uppBound[j];
			delta1 = (y - yl) / (yu - yl);
			delta2 = (yu - y) / (yu - yl);
			rnd = rnd_uni(&rnd_uni_init);
			mut_pow = 1.0 / (eta_m + 1.0);
			if (rnd <= 0.5)
			{
				xy = 1.0 - delta1;
				val = 2.0*rnd + (1.0 - 2.0*rnd)*(pow(xy, (eta_m + 1.0)));
				deltaq = pow(val, mut_pow) - 1.0;
			}
			else
			{
				xy = 1.0 - delta2;
				val = 2.0*(1.0 - rnd) + 2.0*(rnd - 0.5)*(pow(xy, (eta_m + 1.0)));
				deltaq = 1.0 - (pow(val, mut_pow));
			}
			y = y + deltaq*(yu - yl);
			if (y<yl)
				y = yl;
			if (y>yu)
				y = yu;
			ind.x_var[j] = y;
		}
	}
	return;
}

/* Routine for real variable LLmutation */
template <class T>
void LLmutation(T& child, double rate)
{
	int i, mark = 1;
	double a = pow(1.0 - 1.0 * (gen-1) / max_gen, 0.7);
	double rm, y;
	for (i = 0; i < n_var; i++) {
		if (rnd_uni(&rnd_uni_init) <= rate) {
			mark = 0; // at least one component of variable does mutation;
			rm = 0.05 * (rnd_uni(&rnd_uni_init) - 0.5)*(1 - pow(rnd_uni(&rnd_uni_init), -a));
			y = child.x_var[i] + rm * (uppBound[i] - lowBound[i]);

			if (y < lowBound[i])
				y = lowBound[i] + 0.5 * rnd_uni(&rnd_uni_init)*(child.x_var[i] - lowBound[i]);
			if (y > uppBound[i])
				y = uppBound[i] - 0.5 * rnd_uni(&rnd_uni_init)*(uppBound[i] - child.x_var[i]);

			child.x_var[i] = y;
		}
	}
	if (mark) {
		i = int(n_var*rnd_uni(&rnd_uni_init));
		rm = 0.05 * (rnd_uni(&rnd_uni_init) - 0.5)*(1 - pow(rnd_uni(&rnd_uni_init), -a));
		y = child.x_var[i] + rm * (uppBound[i] - lowBound[i]);

		if (y < lowBound[i])
			y = lowBound[i] + 0.5 * rnd_uni(&rnd_uni_init)*(child.x_var[i] - lowBound[i]);
		if (y > uppBound[i])
			y = uppBound[i] - 0.5 * rnd_uni(&rnd_uni_init)*(uppBound[i] - child.x_var[i]);

		child.x_var[i] = y;
	}
}

template <class T>
void crossover(vector<T> &parent, vector <T> &child)
{
	if (!strcmp(optcrossover, "SBX"))
	{
		if (child.size() == 2)
			real_sbx_xover2(parent[0], parent[1], child[0], child[1]);
		else if (child.size()==1)
			real_sbx_xover1(parent[0], parent[1], child[0]);
	}
	else if (!strcmp(optcrossover, "DE"))
	{
		if (parent.size()==3)
			diff_evo_xover1(parent[0], parent[1],parent[2], child[0]);
	}
	else if (!strcmp(optcrossover, "LLBX"))
	{
		LLcrossover(parent[0],parent[1], child[0]);
	}
	else 
	{
		cout<<"please specify a valid crossover method !";
		exit(1);
	}
}

template <class T>
void mutation(T &ind, double rate)
{
	if (!strcmp(optmutation, "PM"))
	{
		realmutation(ind, rate);
	}
	else if (!strcmp(optmutation, "LLM"))
	{
		LLmutation(ind, rate);
	}
	else 
	{
		cout<<"please specify a valid mutation method !";
		exit(1);
	}
}
#endif