#ifndef  _INDIVIDUAL_H_
#define _INDIVIDUAL_H_

/* This file contains the variable and function declarations */


#include "global.h"
#include "testproblem.h"

class IND
{
public:
	IND();
	virtual ~IND();
	void rnd_init();
	void evaluation();
	void operator=(const IND &other);
	bool operator==(const IND & otherind);
	int  check_dominate(const IND & otherind);
	
	vector <double> x_var;
	vector <double> y_obj;
	vector <double> y_tobj;//after translation
	//vector <double> constraint;
	
	double fitness;
	double angvalue;
	int    refno;
};

IND::IND()
{
	for(int i=0; i<n_var; i++)
		x_var.push_back(0.0);
	for (int n = 0; n < n_obj; n++)
	{
		y_obj.push_back(0.0);
		y_tobj.push_back(0.0);
	}
	fitness=0;
	refno=0;
	angvalue=0;
}

IND::~IND()
{
	
}

void IND::rnd_init()
{
    for(int n=0;n<n_var;n++)
	{
        x_var[n] = lowBound[n] + rnd_uni(&rnd_uni_init)*(uppBound[n] - lowBound[n]); 
	}

}

void IND::evaluation()
{	
	objectives(x_var,y_obj);
}

void IND::operator=(const IND &other)
{
    x_var 	= other.x_var;
	y_obj 	= other.y_obj;
	y_tobj = other.y_tobj;
	fitness	= other.fitness;
	refno	= other.refno;
	angvalue= other.angvalue;
}

bool IND::operator==(const IND & otherind)
{
	if(otherind.y_obj==y_obj) return true;
	else return false;
}

int  IND::check_dominate(const IND & otherind)
// 0: equals or nondominates each other 
// 1: dominates otherind;
//-1: dominated by otherind;
{
	int flag1=0, flag2=0;
	for (int n=0; n<n_obj; n++)
	{
		if (y_obj[n]<otherind.y_obj[n]-EPS)
			flag1++;
		else if (y_obj[n]>otherind.y_obj[n]+EPS)
			flag2++;
		if (flag1&&flag2)
			return 0;		
	}
	if (flag1>0 && flag2 == 0)
		return 1;
	else if (flag1 > 0 && flag2 == 0)
		return -1;
	else
		return 0;
}

class REF
{
public:
	REF();
	virtual ~REF();
	
	vector <double> namda;
	vector <int>    array;
	vector <double> member;	
};

REF::REF()
{
	
}

REF::~REF()
{
	
}

#endif