#ifndef __GLOBAL_H_
#define __GLOBAL_H_

#include <iostream>
#include <fstream>
#include <string>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <time.h>
#include <assert.h>
#include <memory.h>
#include <vector>
#include <cassert>


using namespace std;

# define INF 1.0e14
# define EPS 1.0e-10
# define E  2.71828182845905
# define PI 3.141592653589793238462643383279502884197169399375105

#include "random.h"


//******** Parameters in test instance *********************************************
int     n_var=10,      //  the number of variables
		n_obj=2;       //  the number of objectives

vector <double> lowBound;  // lower bounds of decision variables
vector <double> uppBound;  // upper bounds of decision variables


char    probName[256];		// problem name
char    parName[100];		// directory passed to spear.run()
// *********************************************************************************

//******** Parameters in random number *********************************************
int     seed    = 177;
long    rnd_uni_init;        
//**********************************************************************************

//******** Common parameters in MOEAs **********************************************
int		max_gen = 5000,    //  the maximal number of generations
		max_run = 10,      //  the maximal number of runs
		popsize    = 200,  //  the population size
		nfes;              //  the number of function evluations
//**********************************************************************************

//*******  Parameters in SPEA/R ****************************************************
int	   Ksize    = 20,		// restricted mating range
	   unit     = 23;       // popsize=300

char   optrefset[] = "KL";  // other options: "KL", "SLD", "2SLD".... 
int    klayer=20;			// k-layer ref set parameter
int    refsize;				// the reference size

int    divs[] = { 5, 4 };   // for two or mutiple layered approach only --refer to NSGA-III

enum   optextset{ TT, FT, TF, FF }; // options for creating extreme points
optextset ExtreSet = TF;            // TT: by ASF on nondominated set; 
									// FT: by ASF on whole population;
									// TF: general method on nondominated set;
									// FF: general method on whole population;
//**********************************************************************************

char    optcrossover[]="LLBX"; // other options: "SBX","DE", "LLBX"
char    optmutation[]= "LLM";  // other options: "PM","LLM"

//******** Parameters in SBX and PM*************************************************
int		etax    = 20,		   // crossover distribution index
		etam    = 20;		   // mutation distribution index

double  realx, realm;          // probability in SBX crossover and polynomial mutation

//**********************************************************************************

//******* Other global parameters***************************************************
int gen;                       // the current number of generations

//**********************************************************************************
#endif