#ifndef __COMMON_H_
#define __COMMON_H_

#include <algorithm>

#include "global.h"

double distanceArray(double vec1[], double vec2[], int dim)
{
    double sum = 0;
	for(int n=0; n<dim; n++)
	    sum+= (vec1[n] - vec2[n])*(vec1[n] - vec2[n]);
	return sqrt(sum);
}

double distanceVector(vector <double> &vec1, vector <double> &vec2)
{
    double sum = 0;
	for(int n=0; n<vec1.size(); n++)
	    sum+=(vec1[n] - vec2[n])*(vec1[n] - vec2[n]);
	return sqrt(sum);
}

void minusVector(vector<double> &ovect, vector<double> &vect1, vector <double> &vect2)
{
	for (int i = 0; i < vect1.size(); i++)
		ovect[i] = vect1[i] - vect2[i];
	return;
}

double norm_vector(vector <double> &x)
{
	double sum = 0;
	for(int i=0;i<x.size();i++)
        sum = sum + x[i]*x[i];
    return sqrt(sum);
}

double norm_vector(double x[], int size)
{
	double sum = 0;
	for (int i = 0; i<size; i++)
		sum = sum + x[i] * x[i];
	return sqrt(sum);
}

void obj_normalization(vector <double> &vect1, vector <double> &maxvect, vector <double> &minvect)
{

	for (int n = 0; n < vect1.size(); n++)
		vect1[n] = (vect1[n] - minvect[n]) / (maxvect[n] - minvect[n]);
	return;
}

double sum_vector(vector<double>&vec)
{
	double sum = 0;
	for(int i=0;i<vec.size();i++)
        sum = sum + vec[i];
    return sum;
}

template <class T>
T sum_array_match( T array[], T value, int size)
{
	T sum = (T)0;
	for (int i = 0; i < size; i++)
	{
		if (array[i]==value)
			sum += array[i];
	}
	return sum;
}

template <class T>
T sum_array_match(T array1[], T array2[], T value, int size)
{
	T sum = (T)0;
	for (int i = 0; i < size; i++)
	{
		if (array1[i] == value)
			sum += array2[i];
	}
	return sum;
}

double innerproduct(vector <double>&vec1, vector <double>&vec2)
{
    double sum = 0;
	for(int i=0; i<vec1.size(); i++)
		sum+= vec1[i]*vec2[i];
	return sum;
}

double SafeAcos(double x)
{
	if (x < -1.0) x = -1.0;
	else if (x > 1.0) x = 1.0;
	return acos(x);
}

double angleVector(vector <double> &vec1, vector <double> &vec2)
{
	double above = innerproduct(vec1, vec2);
	double below = norm_vector(vec1)*norm_vector(vec2);
	double value = SafeAcos(above / below);
	return value;
}

double angleVector(double vec1[], vector <double> &vec2)
{

	double above = 0;
	for (int n = 0; n < vec2.size(); n++)
		above += vec1[n] * vec2[n];
	double below = norm_vector(vec1, vec2.size())*norm_vector(vec2);
	double value = SafeAcos(above / below);

	return value;
}

void minfastsort(vector <double> &x, vector <int> &idx, int n, int m)
{
    for(int i=0; i<m; i++)
	{
	    for(int j=i+1; j<n; j++)
			if(x[i]>x[j])
			{
			    double temp = x[i];
				x[i]        = x[j];
				x[j]        = temp;
				int id      = idx[i];
				idx[i]      = idx[j];
				idx[j]      = id;
			}
	}
}

void minfastsort(double x[], int idx[], int n, int m)
{
	for (int i = 0; i<m; i++)
	{
		for (int j = i + 1; j<n; j++)
			if (x[i]>x[j])
			{
				double temp = x[i];
				x[i] = x[j];
				x[j] = temp;
				int id = idx[i];
				idx[i] = idx[j];
				idx[j] = id;
			}
	}
}

int nchoosek(int n, int k)
{
	if (k == 0) return 1;
	return (n*nchoosek(n - 1, k - 1) / k);
}

int sizelayer(int m, int k)
{
	return (m*k*(k+3)/2+1);
}

double ASF(vector<double> &x, vector<double> &w)
{
	double asf = -INF;
	for (int i = 0; i < x.size(); i++)
	{
		double tmp = x[i] / w[i];
		if (tmp>asf)
			asf = tmp;
	}
	return asf;
}

bool calc_intercept(vector<double> &x, vector< vector<double> > &A)
{
	int size = A.size(); 

	// append A by adding b to the last column of A.
	for (int i = 0; i < size; i++)
		A[i].push_back(1.0);

	/**///============start guassian elimination===========/**/
	/**/	for (int i = 0; i < size - 1; i++)			   /**/
	/**/		for (int j = i + 1; j < size; j++)		   /**/
	/**/		{										   /**/
	/**/			double tmp = A[j][i] / A[i][i];		   /**/
	/**/			for (int t = 0; t < size + 1; t++)	   /**/
	/**/				A[j][t] -= tmp*A[i][i];			   /**/
	/**/		}										   /**/
	/**/												   /**/
	/**/	x.resize(size);								   /**/
	/**/												   /**/
	/**/	for (int i = size - 1; i >= 0; i++)			   /**/
	/**/	{											   /**/
	/**/		for (int j = i + 1; j < size; j++)		   /**/
	/**/			A[i][size] -= A[i][j] * x[j];		   /**/
	/**/		x[i] = A[i][size] / A[i][i];			   /**/
	/**/	}											   /**/
	/**///==============end guassian elimination===========/**/
	
	// calculate intercepts
	for (int i = 0; i < size; i++)
	{
		if (x[i] < 0) return true;
		x[i] = 1.0 / x[i];
	}

	return false;
}

void random_permutation(vector <int> &perm, int first, int last)
{
	int size = last-first+1;
	if (size != perm.size()) // check size
	{
	}
	vector <int> index(size);
	vector <int> flag(size,1);
	for (int n = 0; n<size; n++)  {
		index[n] = n;
	}

	int num = 0;
	while (num<size)
	{
		int start = int(size*rnd_uni(&rnd_uni_init));
		while (1){
			if (flag[start]){
				perm[num] = index[start];
				flag[start] =0;
				num++;
				break;
			}
			if (start == (size - 1))
				start = 0;
			else
				start++;
		}
	}

}

void random_permutation(int *perm, int size)
{
	int *index = new int[size];
	bool *flag = new bool[size];
	for (int n = 0; n<size; n++)  {
		index[n] = n;
		flag[n] = true;
	}

	int num = 0;
	while (num<size){
		int start = int(size*rnd_uni(&rnd_uni_init));
		while (1){
			if (flag[start]){
				perm[num] = index[start];
				flag[start] = false;
				num++;
				break;
			}
			if (start == (size - 1))
				start = 0;
			else
				start++;
		}
	}

	delete[] index;
	delete[] flag;

}
#endif