#ifndef _WFG_H
#define _WFG_H

//# define PI 3.141592653589793238462643383279502884197169399375105

#define min(a, b) (a)<(b)? (a):(b)
#define max(a, b) (a)>(b)? (a):(b)

#include <math.h>

//void WFG_normalise_z( double *z, double *y, int size );
//void WFG1_t1(double *y, int k,int size  );
//void WFG1_t2(double *y, int k, int size );
//void WFG1_t3(double *y ,int size );
//void WFG1_t4(double *y, int k, int M, int size );

//double b_poly(double y, double alpha );
//double s_linear( double y, const double& A );
//double b_flat(double y,  double A, double B,const double& C);
//double b_param( const double& y,const double& u,const double& A,const double& B,const double& C);
//double s_decept(const double& y, const double& A,const double& B, const double& C);
//double s_multi(const double& y, const double& A,const double& B, const double& C);
//double r_sum(double *y, double *w, int size);
//double r_nonsep(double *y, const double &A, int size);

//void WFG1_shape(double *y);
//void WFG2_shape(double *y);
//void WFG3_shape(double *y);
//void WFG4_shape(double *y);

void WFG_normalise_z( double *dst, double *z, int size )
{
	int i;
	double bound;
	for (i=0; i<size; i++)
	{
		bound=2.0*(i+1);
		dst[i]=z[i]/bound;
	}
}

void subvector(double *v, double *subv,const int head,const int tail)
{
	int i;
	for (i=head; i<tail; i++) //from head to tail-1;
		subv[i-head]=v[i];
	//return subv;
}

/***********trans******************/
double b_poly( double y,  double alpha )
{
	return  pow( y, alpha ) ;
}
double s_linear( double y,  double A )
{
	return fabs( y-A )/fabs( floor( A-y )+A );
}
double b_flat( double y,  double A, double B, double C)
{
	const double tmp1 = min( 0.0, floor( y-B ) ) * A*( B-y )/B;
	const double tmp2 = min( 0.0, floor( C-y ) ) * ( 1.0-A )*( y-C )/( 1.0-C );
	return ( A+tmp1-tmp2 );
}

double b_param( double y, double u, double A, double B, double C)
{
	const double v = A - ( 1.0-2.0*u )*fabs( floor( 0.5-u )+A );
	return pow( y, B + ( C-B )*v );
}

double s_decept( double y,  double A, double B,  double C)
{
	const double tmp1 = floor( y-A+B )*( 1.0-C+( A-B )/B )/( A-B );
    const double tmp2 = floor( A+B-y )*( 1.0-C+( 1.0-A-B )/B )/( 1.0-A-B );
	return 1.0 + ( fabs( y-A )-B )*( tmp1 + tmp2 + 1.0/B ) ;
}

double s_multi(double y,  double A, double B,  double C)
{
  const double tmp1 = fabs( y-C )/( 2.0*( floor( C-y )+C ) );
  const double tmp2 = ( 4.0*A+2.0 )*PI*( 0.5-tmp1 );

  return  ( 1.0 + cos( tmp2 ) + 4.0*B*pow( tmp1, 2.0 ) )/( B+2.0 ) ;
}
double r_sum(double *y, double *w, int size)
{
	 int i;
 double numerator   = 0.0;
  double denominator = 0.0;

  for(i = 0; i <size; i++ )
  {
    numerator   += w[i]*y[i];
    denominator += w[i];
  }

  return ( numerator / denominator );
}
double r_nonsep(double *y, int A, int size)
{
	int k,j;
	double numerator = 0.0;

	double tmp = ceil( A/2.0 );
	double denominator =size*tmp*( 1.0 + 2.0*A - 2.0*tmp )/A;

	for( j = 0; j < size; j++ )
	{
		numerator += y[j];

		for(k = 0; k <= A-2; k++ )
		{
			numerator += fabs( y[j] - y[( j+k+1 ) % size] );
		}
	}

  return ( numerator / denominator );
}

/*********shape***************/
double linear(double *y, int size, int m)
{
	double result=1.0;
	int i;
	for (i=1; i<=size-m; i++)
		result*=y[i-1];
	if (m!=1)
		result*=1-y[size-m];
	return result;
}

double convex(double *y, int size, int m)
{
	double result=1.0;
	int i;
	for (i=1; i<=size-m; i++)
		result*=1.0-cos(0.5*PI*y[i-1]);
	if (m!=1)
		result*=1.0-sin(0.5*PI*y[size-m]);
	return result;
}

double concave(double *y, int size, int m)
{
	double result=1.0;
	int i;
	for (i=1; i<=size-m; i++)
		result*=sin(0.5*PI*y[i-1]);
	if (m!=1)
		result*=cos(0.5*PI*y[size-m]);
	return result;
}

double mixed(double *y, int A, double alpha)
{
	double tmp=2.0*A*PI;
	return pow(1.0-y[0]-cos(tmp*y[0]+0.5*PI)/tmp,alpha);
}

double disc(double *y, int A, double alpha, double beta)
{
	double tmp=A*pow( y[0], beta )*PI;
	return 1.0-pow(y[0],alpha)*pow(cos(tmp),2.0);
}

/*******Framework functions**********/
void calculate_x(double *x, double *t_p, int size, double *A)
{
	int i;
	double tmp;
	for (i=0; i<size-1; i++)
	{
		tmp=max(t_p[size-1],A[i]);
		x[i]=tmp*(t_p[i]-0.5)+0.5;
	}
	x[size-1]=t_p[size-1];
}

void calculate_f(double *y, double D, double x, double *h, int size, double *S)
{
	int i;
	for (i=0; i<size; i++)
		y[i]=D*x+S[i]*h[i];
}
/**********main shape****************/
void WFG_create_A(double *A, int M, int degenerate)
{
	int i;
	if (degenerate)
	{
		for (i=0; i<M; i++)
			A[i]=0;
		A[0]=1;
	}
	else
	{
		for (i=0; i<M; i++)
			A[i]=1;
	}
}

void WFG_calculate_f(double *y, double x, double *h, int size)
{
	int i;
	double S[100];
	for (i=0; i<size; i++)
		S[i]=2.0*(i+1);
	calculate_f(y,1.0,x,h,size, S);
}

void WFG1_shape(double *y, double *t_p, int size)
{
	int i; 
	double A[100], x[100];
	WFG_create_A(A,size,0);
	calculate_x(x,t_p,size,A);
	for (i=1; i<=size-1; i++)
		A[i-1]=convex(x,size,i);
	A[size-1]=mixed(x, 5, 1.0);
	WFG_calculate_f(y,x[size-1],A,size);
}

void WFG2_shape(double *y, double *t_p, int size)
{
	int i; 
	double A[100], x[100];
	WFG_create_A(A,size,0);
	calculate_x(x,t_p,size,A);
	for (i=1; i<=size-1; i++)
		A[i-1]=convex(x,size,i);
	A[size-1]=disc(x, 5, 1.0,1.0);
	WFG_calculate_f(y,x[size-1],A,size);
}

void WFG3_shape(double *y, double *t_p, int size)
{
	int i; 
	double A[100], x[100];
	WFG_create_A(A,size,1);
	calculate_x(x,t_p,size,A);
	for (i=1; i<=size; i++)
		A[i-1]=linear(x,size,i);
	WFG_calculate_f(y,x[size-1],A,size);
}

void WFG4_shape(double *y, double *t_p, int size)
{
	int i; 
	double A[100], x[100];
	WFG_create_A(A,size,0);
	calculate_x(x,t_p,size,A);
	for (i=1; i<=size; i++)
		A[i-1]=concave(x,size,i);
	WFG_calculate_f(y,x[size-1],A,size);
}

/********main transition******************/
void WFG1_t1(double *y, int k,int size  )
{
	int i;
	for (i=k; i<size; i++)
		y[i]=s_linear(y[i],0.35);
}

void WFG1_t2(double *y, int k, int size )
{
	int i;
	for (i=k; i<size; i++)
		y[i]=b_flat( y[i], 0.8, 0.75, 0.85 );
}

void WFG1_t3(double *y, int k, int size )
{
	int i;
	for (i=k; i<size; i++)
		y[i]=b_poly( y[i], 0.02 );
}

void WFG1_t4(double *dst, double *y, int k, int M, int size )
{
	int i;
	int head, tail;
	double w[100];
	double y_sub[100], w_sub[100];
	for (i=0; i<size; i++)
		w[i]=2.0*(i+1);
	for (i=1; i<=M-1; i++)
	{
		head=(i-1)*k/(M-1);
		tail=i*k/(M-1);
		subvector(y,y_sub,head,tail); 
		subvector(w,w_sub,head,tail);
		dst[i-1]=r_sum( y_sub, w_sub, tail-head );
	}
	subvector(y,y_sub,k,size);
	subvector(w,w_sub,k,size);
	dst[M-1]=r_sum( y_sub, w_sub,size-k );
}

void WFG2_t2(double *y, int k, int size )
{
	int i,j=k, l=size-k;
	int head, tail;
	double y_sub[100];
	for (i=k+1; i<=k+l/2; i++, j++)
	{
		head=k+2*(i-k)-2;
		tail=k+2*(i-k);
		subvector(y,y_sub,head,tail);
		y[j]=r_nonsep(y_sub,2,tail-head);
	}
}

void WFG2_t3( double *dst, double *y, int k, int M, int size )
{
	int i;
	double head, tail;
	double w[100];
	double y_sub[100], w_sub[100];

	for (i=0;i<size; i++)
		w[i]=1.0;

	for (i=1; i<=M-1; i++)
	{
		head=(i-1)*k/(M-1);
		tail=i*k/(M-1);
		subvector(y,y_sub,head,tail);
		subvector(w,w_sub,head,tail);
		dst[i-1]=r_sum( y_sub, w_sub, tail-head );
	}
	subvector(y,y_sub,k,size);
	subvector(w,w_sub,k,size);
	dst[M-1]=r_sum( y_sub, w_sub,size-k );
}

void WFG4_t1(double *y, int size )
{
	int i;
	for (i=0; i<size; i++)
		y[i]=s_multi( y[i], 30, 10, 0.35 );

}

void WFG5_t1(double *y, int size )
{
	int i;
	for (i=0; i<size; i++)
		y[i]=s_decept( y[i], 0.35, 0.001, 0.05 );
}

void WFG6_t2( double *dst, double *y, int k, int M, int size )	
{
	int i;
	int head, tail;
	double y_sub[100];
	for (i=1; i<=M-1; i++)
	{
		head=(i-1)*k/(M-1);
		tail=i*k/(M-1);
		subvector(y,y_sub,head,tail);
		dst[i-1]=r_nonsep( y_sub, k/(M-1), tail-head );
	}
	subvector(y,y_sub,k,size);
	dst[M-1]=r_nonsep( y_sub,size-k,size-k );
}

void WFG7_t1(double *y, int k, int size )
{
	int i;
	double  u;
	double w[100];
	double y_sub[100], w_sub[100];

	for (i=0;i<size; i++)
		w[i]=1.0;

	for (i=0; i<k; i++)
	{
		subvector(y,y_sub,i+1,size);
		subvector(w,w_sub,i+1,size);
		u=r_sum( y_sub, w_sub, size-i-1 );
		y[i]=b_param( y[i], u, 0.98/49.98, 0.02, 50 );
	}

}

void WFG8_t1(double *y, int k, int size )
{
	int i;
	double  u;
	double w[100];
	double y_sub[100], w_sub[100];

	for (i=0;i<size; i++)
		w[i]=1.0;

	for (i=k; i<size; i++)
	{
		subvector(y,y_sub,0,i);
		subvector(w,w_sub,0,i);
		u=r_sum( y_sub, w_sub, i );
		y[i]=b_param( y[i], u, 0.98/49.98, 0.02, 50 );
	}

}

void WFG9_t1(double *y, int size )
{
	int i;
	double  u;
	double w[100];
	double y_sub[100], w_sub[100];

	for (i=0;i<size; i++)
		w[i]=1.0;

	for (i=0; i<size-1; i++)
	{
		subvector(y,y_sub,i+1,size);
		subvector(w,w_sub,i+1,size);
		u=r_sum( y_sub, w_sub, size-i-1 );
		y[i]=b_param( y[i], u, 0.98/49.98, 0.02, 50 );
	}

}

void WFG9_t2(double *y, int k, int size )
{
	int i;
	for (i=0; i<k; i++)
		y[i]=s_decept( y[i], 0.35, 0.001, 0.05 );
	for (i=k; i<size; i++)
		y[i]=s_multi( y[i], 30, 95, 0.35 );
}

#endif