#ifndef __OBJECTIVE_H_
#define __OBJECTIVE_H_

#include "global.h"
#include "ExampleProblems.h"

#define pi   3.141592653589793238462643383279502884197169399375105
#define SQR2  sqrt(2)


using namespace WFGT::Toolkit;
using namespace WFGT::Toolkit::Examples;
void objectives(vector<double> x_var, vector <double> &y_obj)
{

	if(!strcmp(probName,"ZDT1"))
	{
		double g = 0;
		
		for(int n=1;n<n_var;n++)
			g+= x_var[n];
		g = 1 + 9*g/(n_var-1);
		
		y_obj[0] = x_var[0];
		y_obj[1] = g*(1 - sqrt(y_obj[0]/g));
		return;
	}


	if(!strcmp(probName,"ZDT2"))
	{
		double g = 0;
		for(int n=1;n<n_var;n++)
			g+= x_var[n];
		g = 1 + 9*g/(n_var-1);
		y_obj[0] = x_var[0];
		y_obj[1] = g*(1 - pow(y_obj[0]/g,2));
	}


	
	if(!strcmp(probName,"ZDT3"))
	{
		double g = 0;
		for(int n=1;n<n_var;n++)
			g+= x_var[n];
		g = 1 + 9*g/(n_var-1);

		y_obj[0] = x_var[0];
		y_obj[1] = g*(1 - sqrt(x_var[0]/g) - x_var[0]*sin(10*pi*x_var[0])/g);
	}


	if(!strcmp(probName,"ZDT4"))
	{
		double g = 0;
		for(int n=1;n<n_var;n++)
		{
			double x = 10*(x_var[n] - 0.5);
			g+= x*x - 10*cos(4*pi*x);
		}
		g = 1 + 10*(n_var-1) + g;
		y_obj[0] = x_var[0];
		y_obj[1] = g*(1- sqrt(y_obj[0]/g));
	}

	if(!strcmp(probName,"ZDT6"))
	{
		double g = 0;
		for(int n=1;n<n_var;n++)
			g+= x_var[n]/(n_var - 1);
		g = 1 + 9*pow(g,0.25) ;

		y_obj[0] = 1 - exp(-4*x_var[0])*pow(sin(6*pi*x_var[0]),6);
		y_obj[1] = g*(1- pow(y_obj[0]/g,2));
	}

	// OKA 1
	if(!strcmp(probName,"OKA-1"))
	{
		double x1 = 2*pi*(x_var[0] - 0.5);
		double x2 = (x_var[1] - 0.5)*10;
		y_obj[0] = x1;
		y_obj[1] = pi - x1 + fabs(x2 - 5*cos(x1));
	}

	if(!strcmp(probName,"OKA-2"))
	{
		double x1 = 2*pow(pi,3)*(x_var[0] - 0.5);
		double x2 = (x_var[1] - 0.5)*10;
		double eta;
		if(x1>=0) eta = pow(x1,1.0/3);
		else      eta = -pow(-x1,1.0/3);

		y_obj[0] = eta;
		y_obj[1] = pi - eta + fabs(x2 - 5*cos(x1));
	}

	if(!strcmp(probName,"DTLZ1"))
	{
		double g = 0, prod;
		for(int n=n_obj-1; n<n_var;n++)				
			g = g + pow(x_var[n]-0.5,2) - cos(20*pi*(x_var[n] - 0.5));
		g =1.0+100*(n_var- n_obj + 1 + g);

		prod=g;
		for (int n=0; n<n_obj-1; n++)
			prod*=x_var[n];
		y_obj[0]=0.5*prod;

		for (int i=1; i<n_obj; i++)
		{
			prod=g;
			for (int j=0; j<n_obj-1-i; j++)
				prod*=x_var[j];
			prod*=(1.0-x_var[n_obj-1-i]);
			y_obj[i]=0.5*prod;
		}
	}

	if(!strcmp(probName,"DTLZ2"))
	{
		double g = 0, prod;
		
		for(int n=n_obj-1; n<n_var;n++)				
		{
			double x = (x_var[n] - 0.5);
			g = g + x*x;
		}
		g=1.0+g;
		prod=g;
		for (int n=0; n<n_obj-1; n++)
			prod*=cos(0.5*pi*x_var[n]);
		y_obj[0]=prod;

		for (int i=1; i<n_obj; i++)
		{
			prod=g;
			for (int j=0; j<n_obj-1-i; j++)
				prod*=cos(0.5*pi*x_var[j]);
			prod*=sin(0.5*pi*x_var[n_obj-1-i]);
			y_obj[i]=5*i*prod;
		}
	}

	if(!strcmp(probName,"DTLZ3"))
	{
		double g = 0, prod;
		
		for(int n=n_obj-1; n<n_var;n++)				
		{
			double x = (x_var[n] - 0.5);
			g = g + x*x-cos(20*pi*x);
		}
		g=1.0+(g+n_var-n_obj+1);
		prod=g;
		for (int n=0; n<n_obj-1; n++)
			prod*=cos(0.5*pi*x_var[n]);
		y_obj[0]=prod;

		for (int i=1; i<n_obj; i++)
		{
			prod=g;
			for (int j=0; j<n_obj-1-i; j++)
				prod*=cos(0.5*pi*x_var[j]);
			prod*=sin(0.5*pi*x_var[n_obj-1-i]);
			y_obj[i]=prod;
		}
	}

   if(!strcmp(probName,"DTLZ4"))
	{
		double g = 0, prod;
		
		for(int n=n_obj-1; n<n_var;n++)				
		{
			double x = (x_var[n] - 0.5);
			g = g + x*x;;
		}

		
		g=1.0+g;
		prod=g;
		for (int n=0; n<n_obj-1; n++)
		{
			prod*=cos(0.5*pi*pow(x_var[n], 100.0));
		}
		y_obj[0]=prod;

		for (int i=1; i<n_obj; i++)
		{
			prod=g;
			for (int j=0; j<n_obj-1-i; j++)
				prod*=cos(0.5*pi*pow(x_var[j],100.0));
			prod*=sin(0.5*pi*pow(x_var[n_obj-1-i],100.0));
			y_obj[i]=prod;
		}
	}

   	if(!strcmp(probName,"WFG1"))
	{
	int vk=4*(n_obj-1);

	y_obj = Problems::WFG2(x_var, vk, n_obj);
	}

	if(!strcmp(probName,"WFG2"))
	{
			int vk=4*(n_obj-1);

	y_obj = Problems::WFG2(x_var, vk, n_obj);
	}

	if(!strcmp(probName,"WFG3"))
	{
			int vk=4*(n_obj-1);

	y_obj = Problems::WFG3(x_var, vk, n_obj);
	}

	if(!strcmp(probName,"WFG4"))
	{
			int vk=4*(n_obj-1);

	y_obj = Problems::WFG4(x_var, vk, n_obj);
	}

	if(!strcmp(probName,"WFG5"))
	{
			int vk=4*(n_obj-1);

	y_obj = Problems::WFG5(x_var, vk, n_obj);
	}

	if(!strcmp(probName,"WFG6"))
	{
			int vk=4*(n_obj-1);

	y_obj = Problems::WFG6(x_var, vk, n_obj);
	}

	if(!strcmp(probName,"WFG7"))
	{
			int vk=4*(n_obj-1);

	y_obj = Problems::WFG7(x_var, vk, n_obj);
	}

	if(!strcmp(probName,"WFG8"))
	{
			int vk=4*(n_obj-1);

	y_obj = Problems::WFG8(x_var, vk, n_obj);
	}

	if(!strcmp(probName,"WFG9"))
	{
			int vk=4*(n_obj-1);

	y_obj = Problems::WFG9(x_var, vk, n_obj);
	}

	//******************MOP Test Suite**********************//
	//MOP1-5 are biobjective, MOP6-7 triobjective, # variables=10//

	// MOP1
	if (!strcmp(probName, "MOP1"))
	{
		double sum = 0, g = 0, t;
		int i;
		for (i = 1; i < n_var; i++)
		{
			t = x_var[i] - sin(0.5*pi*x_var[0]);
			sum += -0.9*t*t + pow(fabs(t), 0.6);
		}
		g = 1 + 2 * sin(pi*x_var[0])*sum;
		y_obj[0] = g*x_var[0];
		y_obj[1] = g*(1 - pow(x_var[0], 0.5));
	}

	// MOP2
	if (!strcmp(probName, "MOP2"))
	{
		double sum = 0, g = 0, t;
		int i;
		for (i = 1; i < n_var; i++)
		{
			t = x_var[i] - sin(0.5*pi*x_var[0]);
			sum += fabs(t) / (1 + exp(5.0*fabs(t)));
		}
		g = 1 + 10 * sin(pi*x_var[0])*sum;
		y_obj[0] = g*x_var[0];
		y_obj[1] = g*(1 - pow(x_var[0], 2.0));
	}

	// MOP3
	if (!strcmp(probName, "MOP3"))
	{
		double sum = 0, g = 0, t;
		int i;
		for (i = 1; i < n_var; i++)
		{
			t = x_var[i] - sin(0.5*pi*x_var[0]);
			sum += fabs(t) / (1 + exp(5.0*fabs(t)));
		}
		g = 1 + 10 * sin(0.5*pi*x_var[0])*sum;
		y_obj[0] = g*cos(0.5*pi*x_var[0]);
		y_obj[1] = g*sin(0.5*pi*x_var[0]);
	}

	// MOP4
	if (!strcmp(probName, "MOP4"))
	{
		double sum = 0, g = 0, t;
		int i;
		for (i = 1; i < n_var; i++)
		{
			t = x_var[i] - sin(0.5*pi*x_var[0]);
			sum += fabs(t) / (1 + exp(5.0*fabs(t)));
		}
		g = 1 + 10 * sin(pi*x_var[0])*sum;
		y_obj[0] = g*x_var[0];
		y_obj[1] = g*(1 - pow(x_var[0], 0.5)*pow(cos(2.0*pi*x_var[0]), 2.0));
	}

	// MOP5
	if (!strcmp(probName, "MOP5"))
	{
		double sum = 0, g = 0, t;
		int i;
		for (i = 1; i < n_var; i++)
		{
			t = x_var[i] - sin(0.5*pi*x_var[0]);
			sum += -0.9*t*t + pow(fabs(t), 0.6);
		}
		g = 1 + 2 * fabs(cos(pi*x_var[0]))*sum;
		y_obj[0] = g*x_var[0];
		y_obj[1] = g*(1 - pow(x_var[0], 0.5));
	}

	// MOP6
	if (!strcmp(probName, "MOP6"))
	{
		double sum = 0, g = 0, t;
		int i;
		for (i = 2; i < n_var; i++)
		{
			t = x_var[i] - x_var[0] * x_var[1];
			sum += -0.9*t*t + pow(fabs(t), 0.6);
		}
		g = 1 + 2 * sin(pi*x_var[0])*sum;
		y_obj[0] = g*x_var[0] * x_var[1];
		y_obj[1] = g*x_var[0] * (1 - x_var[1]);
		y_obj[2] = g*(1 - x_var[0]);
	}

	// MOP7
	if (!strcmp(probName, "MOP7"))
	{
		double sum = 0, g = 0, t;
		int i;
		for (i = 2; i < n_var; i++)
		{
			t = x_var[i] - x_var[0] * x_var[1];
			sum += -0.9*t*t + pow(fabs(t), 0.6);
		}
		g = 1 + 2 * sin(pi*x_var[0])*sum;
		y_obj[0] = g*cos(0.5*pi*x_var[0])*cos(0.5*pi*x_var[1]);
		y_obj[1] = g*cos(0.5*pi*x_var[0])*sin(0.5*pi*x_var[1]);
		y_obj[2] = g*sin(0.5*pi*x_var[0]);
	}
}


#endif