//==========================================================================
//  Implementation of SPEA/R for Continuous Multiobjective Optimization Problems (2007)
//
//  Please refer to the following paper for more detail.
//  Shouyong Jiang and Shengxiang Yang, "A Pareto strength evolutionary algorithm based 
//  on reference direction for multiobjective and many-objective optimization", IEEE 
//  Transaction on Evolutionary Computation, in press, 2016.
//
//  The source code of SPEA/R is implemented by Shouyong Jiang and Shengxiang Yang
//
//  If you have any questions about the codes, please contact 
//  math4neu@gmail.com
//===========================================================================


#include "global.h"
#include "spear.h"
#include "individual.h"
//#include <sys/stat.h>
#include <direct.h>

int main()
{

	// The settings of algorithms for an array of test problems
	int pop[] = {100, 100, 100, 100, 100, 313, 313, 300, 300};     // population size
	//char *prob[] = { "UFP1", "UFP2", "UFP3", "UFP4", "UFP5", "UFP6", "UFP7", "UFP8", "UFP9", "UFP10"};
	char *prob[] = { "MOP1", "MOP2", "MOP3", "MOP4", "MOP5", "MOP6", "MOP7" };
	//char *prob[] = {"WFG1","WFG2","WFG3", "WFG4", "WFG5", "WFG6", "WFG7", "WFG8", "WFG9"};

	int  nobjs[] = { 2, 2, 2, 2, 2, 3, 3 };
	for (int i=4; i<7; i++)
	{
		// the parameter setting of test instance
		popsize = pop[i];
		n_obj = nobjs[i];
		strcpy_s(probName,prob[i]);
		lowBound.resize(n_var);
		uppBound.resize(n_var);

		for (int k=0; k< n_var; k++)
		{
			lowBound[k]=0,uppBound[k]=1;
		}

		// set output path 
		string path = "H:\\data\\Test\\";
		char parName1[256];
		sprintf_s(parName1,path.append("%s_gen%i_obj%i").c_str(),probName,max_gen,n_obj);
		if (_mkdir(parName1))
			cout<<"This file has already existed"<<endl;
		
		//=========Start each run of SPEA/R====================================================//==
																							   //
		for(int run=1; run<=max_run; run++) 												   //
		{																					   //
			parName[0]='\0';																   //
			sprintf_s(parName,"%s\\run_%d",parName1,run);									   //
			if (_mkdir(parName))															   //
				cout<<"This file has already existed"<<endl;								   //
  																							   //
			SPEAR algSPEAR;																	   //
			algSPEAR.spear_run(run);  														   //
		}																					   //
		//=========End each run of SPEA/R======================================================//==

	}
	return 0;
}
