#ifndef __GLOBAL_H_
#define __GLOBAL_H_

#include <iostream>
#include <fstream>
#include <string>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <time.h>
#include <memory.h>
#include <vector>
#include <cassert>


using namespace std;

#define pi 3.141592653589793238462643383279502884197169399375105

#include "..\common\random.h"


//******** Parameters in test instance *********************************************
int     vk,        // position-related variables in WFG
		nvar,      //  the number of variables
		nobj;      //  the number of objectives


double  lb = 0, ub = 1; // normalized bounds here, denormalization is handled in objective functions 
double lowBound[50],uppBound[50];

double  CES=1.0E-300;
char    strTestInstance[256];
char    parName[100];
// *********************************************************************************

//******** Parameters in random number *********************************************
int     seed    = 177;
long    rnd_uni_init;        
//**********************************************************************************

//******** Common parameters in MOEAs **********************************************
int		max_gen =300,    //  the maximal number of generations
		max_run = 1,      //  the maximal number of runs
		pops    = 100,    //  the population size
		nfes,             //  the number of function evluations
		itt;              // iteration =gen;
//**********************************************************************************

//*******  Dynamic paramter configuration*******************************************
int  nt = 10,           // frequency
     taut = 20,          // severity
     T0=50;                // number of generations for original static optimization

int   Parar=0;              // unchanged index within a time window, 0 at the beginning
int   detectors = 10;       // maximum number of detectors

double Tt=0.0;               // real time steps
double eta=0.4;             // proportion of immigrants

//********Global variable for SDP instances
double rnd_rt;  // random value between 0 and 1
int	nobj_l = 2, // minimal number of objectives
	nobj_u = 3, // maximal number of objectives
	nvar_l = 10, // minimal number of variables
	nvar_u = 20; // maximal number of variables

double sdp_y[256]; // for sdp1 problem

vector <double> normvector; // normal vector of the hyper-plane
char   strFunctionType[256], 
       strAlgorithmType[256]; 
//***************************************************************************************

//******** Parameters in SBX *******************************************************
int		etax    = 20,     
		etam    = 20;

double  realx, realm;    // probability in SBX crossover and polynomial mutation

int     gID;
//**********************************************************************************

#endif