#ifndef __COMMON_H_
#define __COMMON_H_

#include "..\common\global.h"
#include "..\common\mylib.h"

template <class T>
int dominance(vector <double> &y_obj1, vector <double> &y_obj2, T* ind_arr)
{
	int dm=0,dl=0,de=0;
	for (int i=0; i<nobj;i++)
	{
		if (y_obj1[i]>y_obj2[i])
			dm+=1;
		else
			if (y_obj1[i]=y_obj2[i])
				de+=1;
			else
				dl+=1;
		if (dm>0 && dl>0)
			break;
	}
	if (dm==nobj)
		return -1;
	if (dl==nobj)
		return 1;
	return 0;
}

void random_permutation(int *perm, int size)
{
	int *index = new int[size];
	bool *flag = new bool[size];
    for(int n=0; n<size; n++)  {
		index[n] = n;
		flag[n]  = true;
	}

	int num = 0;
	while(num<size){
	    int start = int(size*rnd_uni(&rnd_uni_init));
		while(1){
			if(flag[start]){
				perm[num] = index[start];
				flag[start] = false;
				num++;
				break;
			}
			if(start==(size-1))
				start = 0;
			else
			    start++;
		}
	}

	delete [] index;
	delete [] flag;

}

#endif