#ifndef __CSGEAIND_H_
#define __CSGEAIND_H_

#include "..\common\global.h"
#include "..\common\objective.h"

class CSGEAInd{
public:
	CSGEAInd();
	virtual ~CSGEAInd();

	vector <double> x_var;
	vector <double> y_obj;

	void   rnd_init();
	void   obj_eval();

    bool   operator<(const CSGEAInd &ind2);
	bool   operator<<(const CSGEAInd &ind2);
    bool   operator==(const CSGEAInd &ind2);
    void   operator=(const CSGEAInd &ind2);

	int compare(const CSGEAInd &ind2);
	void show_objective();
	void show_variable();

	int    rank, ncount;
	double fitness;

};

CSGEAInd::CSGEAInd()
{
	for(int i=0; i<nvar_u; i++)
		x_var.push_back(0.0);
	for(int n=0; n<nobj_u; n++)
	{
        y_obj.push_back(0.0);
	}
	fitness=0;
	ncount=0;
}

CSGEAInd::~CSGEAInd()
{

}

void CSGEAInd::rnd_init()
{
    for(int n=0;n<nvar_u;n++)
	{
        x_var[n] = lowBound[n] + rnd_uni(&rnd_uni_init)*(uppBound[n] - lowBound[n]); 
	}

}

void CSGEAInd::obj_eval()
{
	objective(x_var, y_obj);
}


void CSGEAInd::show_objective()
{
    for(int n=0; n<nobj; n++)
		printf("%f ",y_obj[n]);
	printf("\n");
}

void CSGEAInd::show_variable()
{
    for(int n=0; n<nvar; n++)
		printf("%f ",x_var[n]);
	printf("\n");
}

void CSGEAInd::operator=(const CSGEAInd &ind2)
{
    x_var = ind2.x_var;
	y_obj = ind2.y_obj;
	rank  = ind2.rank;
	fitness=ind2.fitness;
	ncount =ind2.ncount;

}

bool CSGEAInd::operator<(const CSGEAInd &ind2)
{
	bool dominated = true;
    for(int n=0; n<nobj; n++)
	{
		if(ind2.y_obj[n]<y_obj[n]) return false;
	}
	if(ind2.y_obj==y_obj) return false;
	return dominated;
}


bool CSGEAInd::operator<<(const CSGEAInd &ind2)
{
	bool dominated = true;
    for(int n=0; n<nobj; n++)
	{
		if(ind2.y_obj[n]<y_obj[n]  - 0.0001) return false;
	}
	if(ind2.y_obj==y_obj) return false;
	return dominated;
}

bool CSGEAInd::operator==(const CSGEAInd &ind2)
{
	if(ind2.y_obj==y_obj) return true;
	else return false;
}

int CSGEAInd::compare(const CSGEAInd &ind2)
{
	// 2: equals ind2
	// 1: dominated by ind2;
	// 0: mutually nondominated;
	//-1: dominate ind2
	int less=0, more=0;
    for(int n=0; n<nobj; n++)
	{
		if (fabs(ind2.y_obj[n]-y_obj[n])<CES) continue;
		if(ind2.y_obj[n]<y_obj[n]) more++;
		if(ind2.y_obj[n]>y_obj[n]) less++;
		if (more>0 && less>0) return 0;
	}
	if (more>0 && less==0) return 1;
	if (less>0 && more==0) return -1;
	if (less==0 && more==0) return 2;
}
class CFIN  
{
public:
	CFIN();
	virtual ~CFIN();

	CSGEAInd        indiv;     // best solution
	double          density;
	double			fitness;

    void  operator=(const CFIN &sub2);
};

CFIN::CFIN()
{
}

CFIN::~CFIN(){
}



void CFIN::operator=(const CFIN &sub2){
    indiv  = sub2.indiv;
}

#endif