//  ===================================================================================================== ////
//  Implementation of SGEA for Dynamic Multiobjective Optimization (now in debug mode,2016)				  //
//																										  //
//  Refer to the following paper for more detail in terms of algorithm and parameter setting			  //
//  Shouyong Jiang and Shengxiang Yang, "A steady-state and generational evolutionary algorithm for		  //
//  dynamic multiobjective optimization,'' IEEE Transactions on Evolutionary Computation, in press, 2016. //
//																										  //
//  The component functions of each test instance can be found in "objective.h".						  //
//																										  //
//  The source code of SGEA was implemented by Shouyong Jiang.											  //
//																										  //
//  If you have any questions about the codes, please contact											  //
//  Shouyong Jiang at math4neu@gmail.com  or Shengxiang Yang at syang@dmu.ac.uk							  //
//  ===================================================================================================== ////


#include "..\common\global.h"
#include "sgeafunc.h"
#include <direct.h>
#include <random>

void execute();

void main()
{
	// The settings of algorithm
	int pop[] = { 100, 100, 100, 100, 100, 100, 100, 100, 100 };     // population size

	int obj[] = { 2, 2, 2, 3, 3, 2, 2, 2, 2 };       // number of objective functions
	int var[] = { 11, 13, 10, 12, 12, 10, 10, 10, 11 };       // dimensionality of search space

	//char *ins[] = { "FDA1", "FDA2", "FDA3", "FDA4", "FDA5", "dMOP1", "dMOP2", "dMOP3", "ZJZ1" };
	char *ins[] = {"SDP1", "SDP2", "SDP3", "SDP4", "SDP5", "SDP6", "SDP7", "SDP8", "SDP9", "SDP10", "SDP11", "SDP12", "SDP13", "SDP914", "SDP915"};

	for (int i = 12; i < 13; i++)
	{
		// the parameter setting of test instance                
		// bounds for variables
		int tnvar = nvar_l;
		if (!strcmp(strTestInstance, "SDP12"))
			tnvar = nvar_u;
		for (int k = nobj - 1; k < tnvar; k++)
		{
			lowBound[k] = lb, uppBound[k] = ub;
		}

		//pops = pop[i];
		max_gen = 50 + 3 * nt*taut;
		strcpy_s(strTestInstance, ins[i]);

		execute();
	}
}

void execute()
{
	std::fstream fout;
	char filename[1024];
	char parName1[100];

	// set path for output
	string path = "data";
	_mkdir(path.c_str());

	sprintf_s(parName1, path.append("\\%s").c_str(), strTestInstance);
	if (_mkdir(parName1))
		cout << "this file has already existed."<<endl;

	for (int run = 1; run <= max_run; run++)
	{
		sprintf_s(parName, "%s\\run_%d", parName1, run);
		if (_mkdir(parName))
			cout << "this file has already existed."<<endl;

		// initialize nobj, nvar
		nobj = nobj_l;
		nobj_u = nobj_l;
		if (!strcmp(strTestInstance, "SDP13"))
			nobj_u = 3;

		nvar = nvar_l;
		nvar_u = nvar_l;
		if (!strcmp(strTestInstance, "SDP12"))
			nvar_u = 20;

		CSGEA  SGEA;
		SGEA.execute(run);
	}

}