"""Standard .ht to .html file generator
"""
import os
import sys

from Skeleton import Skeleton
from Sidebar import Sidebar
from HTParser import HTParser
from LinkFixer import LinkFixer
from Banner import Banner
from VISidebar import VISidebar

sitelinks = [
    ('home.html',     'Home Page'),
    ('links.html',    'Links'),
    ('../home.html',  'Full Graphics')
    ]

class VIGenerator(Skeleton, VISidebar, Banner):

    AUTHOR = "Phillip Lord"
    EMAIL = "p.lord@russet.org.uk"

    def __init__(self, file, rootdir, relthis):
        root, ext = os.path.splitext(file)
        html = root + '.html'
        p = self._parser = HTParser(file, self.AUTHOR, self.EMAIL)
        self._linkfixer = LinkFixer(html, rootdir, relthis)
        self.__body = None
        p.process_sidebar()
        self._linkfixer.massage(p.sidebar)
        VISidebar.__init__(self, p.sidebar)
        self.__d = {'rootdir': rootdir}
        Banner.__init__(self, sitelinks)
        # kludge!
        for i in range(len(p.sidebar)-1, -1, -1):
            if p.sidebar[i] == 'Email Us':
                p.sidebar[i] = 'Email'
                break

    def get_title(self):
        return self._parser.get('title')

    def get_sidebar(self):
        return VISidebar.get_sidebar(self)

    def get_banner(self):
        return Banner.get_banner(self)    

    def get_body(self):
        if self.__body is None:
            self.__body = self._parser.fp.read()
        return self.__body

    def get_corner(self):
        return ''
#<br>
# <center>
#      <a href="%(rootdir)s/home.html">
#      <img src="%(rootdir)s/images/europe_icon.gif"></a></centre>''' % \
#      self.__d

    def get_lightshade(self):
        return '#ffffff'

    def get_mediumshade(self):
        return '#ffffff';

    def get_darkshade(self):
        return '#ffffff'

    def get_bgcolor(self):
        return '#bbbbbb';

    def get_sidebar_bgcolor(self):
        return '#ffffff';
    
