import sys
from Sidebar import Sidebar
from types import StringType
try:
    from cStringIO import StringIO
except IOError:
    from StringIO import StringIO

class HomeSidebar(Sidebar):

    ## Irritatingly this code is taken entirely from the super class
    ## except for a single line in the do_link which is changed. I
    ## can't just do a straight override because the double underscore
    ## means a private method call. 
    def get_sidebar(self):
        stdout = sys.stdout
        html = StringIO()
        try:
            sys.stdout = html
            self.__start_table()
            self.__do_link()
            self.__finish()
        finally:
            sys.stdout = stdout
        return html.getvalue()

    def __start_table(self):
        print '<!-- start of sidebar table -->'
        print '<TABLE WIDTH="100%" BORDER=0 CELLSPACING=0 CELLPADDING=3'
        print '       BGCOLOR="%s">' % self.get_bgcolor()

    def __finish(self):
        print '</TABLE><!-- end of sidebar table -->'

    def __do_link(self):
        done_one = 0
        for item in self.links:
            if type(item) == StringType:
                # category header
                if done_one:
                    # get some separation between header and last item
                    print '<TR><TD BGCOLOR="%s">&nbsp;' % (
                        self.get_lightshade())
                else:
                    done_one = 1
                print '<TR><TD BGCOLOR="%s"><B><FONT COLOR="%s">' % (
                    ## (PWL) Here is the only change,
                    ## get_sidebar_bgcolor rather than get_bgcolor
                    self.get_darkshade(), self.get_sidebar_bgcolor())
                print item
                print '</FONT></B></TD></TR>'
            else:
                if len(item) == 3:
                    url, text, extra = item
                else:
                    url, text = item
                    extra = ''
                if url is None:
                    s = text
                else:
                    s = '<A HREF="%s">%s</A>' % (url, text)
                print '<TR><TD BGCOLOR="%s">' % self.get_lightshade()
                print '%s%s' % (s, extra)
                print '</TD></TR>'
