"""Standard .ht to .html file generator
"""
import os
import sys

from Skeleton import Skeleton
from Sidebar import Sidebar
from HTParser import HTParser
from LinkFixer import LinkFixer
from Banner import Banner
from HomeSidebar import HomeSidebar

sitelinks = [
    ('#content',  'Skip&nbsp;to&nbsp;Content'),
    ('home.html',     'Home&nbsp;Page'),
    ('http://www.cs.man.ac.uk', 'Dept.&nbsp;Home&nbsp;Page'),
    ]

class HomeGenerator(Skeleton, HomeSidebar, Banner):
    
    AUTHOR = "Phillip Lord"
    EMAIL = "p.lord@russet.org.uk"

    def __init__(self, file, rootdir, relthis):
        root, ext = os.path.splitext(file)
        html = root + '.html'
        p = self._parser = HTParser(file, self.AUTHOR, self.EMAIL)
        self._linkfixer = LinkFixer(html, rootdir, relthis)
        self.__body = None
        p.process_sidebar()
        self._linkfixer.massage(p.sidebar)
        HomeSidebar.__init__(self, p.sidebar)
        self.__d = {'rootdir': rootdir}
        Banner.__init__(self, sitelinks)
        # kludge!
        for i in range(len(p.sidebar)-1, -1, -1):
            if p.sidebar[i] == 'Email Us':
                p.sidebar[i] = 'Email'
                break

    def get_title(self):
        return self._parser.get('title')

    def get_sidebar(self):
        return HomeSidebar.get_sidebar(self)

    def get_banner(self):
        return Banner.get_banner(self)    

    def get_body(self):
        if self.__body is None:
            self.__body = self._parser.fp.read()

        ## add anchor for content
        self.__body = '<a name="content"/>\n' + self.__body
        return self.__body

    def get_corner(self):
        return '''
<br>
<center>
    <a href="%(rootdir)s/home.html">
    <img src="%(rootdir)s/images/europe_icon.gif"></a></centre>''' % \
    self.__d

    def get_lightshade(self):
        return '#00cc00'

    def get_mediumshade(self):
        return '#000044';

    def get_darkshade(self):
        return '#009900'

    def get_bgcolor(self):
        return '#bbbbbb';

    def get_sidebar_bgcolor(self):
        return '#ffffff';
    
