<?php
/*
  Plugin Name: Kblog Metadata
  Plugin URI: http://www.knowledgeblog.org
  Description: Adds metadata about posts in lots of formats
  Version: 0.1
  Author: Phillip Lord
  Author URI: http://www.knowledgeblog.org
  Email: knowledgeblog@googlegroups.com
  
  Copyright 2011 Phillip Lord (phillip.lord@newcastle.ac.uk)
  Newcastle University

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


/* Begin COINS section */

add_filter( "the_content", "kblog_metadata_coins_content");

function kblog_metadata_coins_content($content)
{
    $authors = kblog_metadata_get_authors();
    
    $first_sentinel = true;
    $author_string = "";
    foreach( $authors as $author ){
        // the insanity that is coins treats the first author and all subsequent authors differently. 
        // The first author can be split into first name/last name. All others can't. 
        if( $first_sentinel ){
            $first_sentinel = false;
            $author_string .= "rft.aulast=".urlencode($author['lastname']).
                "&amp;rft.aufirst=".urlencode($author['firstname']);
            
        }
        else{
            $author_string .= "&amp;rft.au=".
                urlencode( kblog_metadata_concat_name($author) );
        }
        
    }
    $title = urlencode( get_the_title() );
    $blogtitle = urlencode( get_bloginfo('name') );
    $time = get_the_time( 'Y-m-d' );
    $permalink = urlencode( get_permalink() );
    
    return
        "<!-- coins metadata inserted by kblog-metadata -->\n" .
        '<span class="Z3988" title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Adc&amp;rfr_id='. 
        urlencode( "kblog-metadata.php" ) .  
        "&amp;rft.title=$title&amp;rft.source=$blogtitle&amp;rft.date=$time&amp;rft.identifier=$permalink&amp;" .
        $author_string . 
        '&amp;rft.format=text&amp;rft.language=English"></span>' .
        $content;
}



// End COINS

// Google Scholar meta tags
add_action( "wp_head", "kblog_metadata_header_metatags" );

function kblog_metadata_header_metatags(){
    echo "<!--Google Scholar tags by kblog-metadata.php-->\n";
    echo kblog_metadata_get_metatags();
}


function kblog_metadata_get_metatags(){
    // multidimensional, cause multiple authors
    $metadata_items = array
        (
         array( "resource_type"=>"knowledgeblog" ),
         array( "citation_journal_title"=>htmlentities( get_bloginfo( 'name' ) ) ),
         array( "citation_publication_date"=>htmlentities( get_the_time( 'Y/m/d' ) ) ),
         );

    
    if( is_single() ){
        $authors = kblog_metadata_get_authors();
        foreach( $authors as $author ){
            $metadata_items[] = array
                ( "citation_author"=>htmlentities(kblog_metadata_concat_name($author)));
        }
        
        $metadata_items[] = array
            ("citation_title"=>htmlentities( kblog_metadata_get_the_title() ) );
    }
    
    return kblog_metadata_generate_metatags( $metadata_items );
}


// End Google Scholar meta tags

// open graph protocol
add_filter( "language_attributes", "kblog_metadata_language_attributes_ogp_filter" );

function kblog_metadata_language_attributes_ogp_filter( $language_attributes )
{
    if( is_single() ){
        $language_attributes .= ' xmlns:article="http://ogp.me/ns/article#"';
    }

    return $language_attributes . ' xmlns:og="http://ogp.me/ns#" ';
}

add_action( "wp_head", "kblog_metadata_header_ogp_metatags" );

function kblog_metadata_header_ogp_metatags(){
    echo "<!--OGP tags by kblog-metadata.php-->\n";
    echo kblog_metadata_get_ogp_metatags();
}

function kblog_metadata_get_ogp_metatags(){
    // got to here
    $metadata_items = array();
    $metadata_items[] = array
        ("og:site_name"=>htmlentities( get_bloginfo() ) );
    
    
    if( is_single() ){
        $metadata_items[] = array
            ("og:title"=>htmlentities( kblog_metadata_get_the_title() ) );
        $metadata_items[] = array
            ("og:type"=>"article");
        $metadata_items[] = array
            ("og:url"=>kblog_metadata_get_permalink() );

        
        $authors = kblog_metadata_get_authors();
        foreach( $authors as $author ){
            $metadata_items[] = array
                ( "article:author"=>htmlentities(kblog_metadata_concat_name($author)));
        }
        
        $metadata_items[] = array
            ( "article:published_date"=>get_the_time("Y-m-d") );
    }
    else{
        $metadata_items[] = array
            ("og:type"=>"website");
        $metadata_items[] = array
            ("og:url"=>home_url());
    }
    
    return kblog_metadata_generate_metatags( $metadata_items );
}

// end open graph protocol



// Generally useful functions

function kblog_metadata_generate_metatags($metadata_items){
    $metadata = "";
    foreach( $metadata_items as $item ){
        // single element for each
        foreach( $item as $key=>$value ){
            // <meta name="resource_type" content="knowledgeblog"/>
            $metadata .=  kblog_metadata_meta_tag( $key, $value );
        }
    }
    return $metadata;
}

    

function kblog_metadata_meta_tag($key, $value){
    return '<meta name="' . $key . 
        '" content="' . $value . '"/>' . "\n";
}

function kblog_metadata_concat_name( $author ){
    return $author["firstname"] . " " . $author[ "lastname" ];
}



/*
 * Fetch the permalink. Works outside the loop. 
 */
function kblog_metadata_get_permalink(){
    $postID = false;
    if( !get_the_ID() ){
        global $wp_query;
        $postID = $wp_query->post->ID;
    }
    return get_permalink( $postID );
}



/* 
 * Fetch the title. Works outside the loop
 */
function kblog_metadata_get_the_title(){
    $postID = false;
    if( !get_the_ID() ){
        global $wp_query;
        $postID = $wp_query->post->ID;
    }
    return get_the_title( $postID );
}


/*
 * Fetch the authors, as an array, each with firstname, lastname.
 * $authorID is optional if used inside the loop. 
 */
function kblog_metadata_get_authors()
{
    $authorID = false;

    if( !get_the_author() ){
        // we are outside the loop so get_the_id don't work. 
        global $wp_query;
        $authorID = $wp_query->post->post_author;
    }



    $authors = array();
    // currently just using wordpress API. Add coauthors, kblog_authors later.
    $author = array
        ( 'firstname'=>get_the_author_meta( "first_name", $authorID ),
          'lastname'=>get_the_author_meta( "last_name", $authorID )
          );
    $authors[] = $author;

    /*  $authors = array( */
    /* array( */
    /*                        'firstname'=>"Phillip", */
    /*                       'lastname'=>"Lord" */
    /*                        ), */
    /*                  array( */
    /*                        'firstname'=>"John", */
    /*                        'lastname'=>"Smith" */
    /*                        ), */
    /*                  ); */

    return $authors;
}


?>