#!/usr/local/bin/perl -w

use lib 't', 'lib';
use strict;
use Test;

BEGIN{ plan tests => 14 }

use Prints::PrintsHandle;

use factory;
use data;

#### Get handle, make fprint, make sequence. All previously tested
my $handle = factory;

my $f_data = data::fprint_accession;
my $s_data = data::seqn_accession;
my $m_data = data::motif_data;
my $m_data2 = data::motif_data2;

my $sequence = sequence( $handle, $s_data->{accession} );
my $fingerprint = fingerprint( $handle, $f_data->{accession} );

ok( 1 );


#### get a set of motifs
my @motifs = $fingerprint->motifs( {sequence=>$sequence} );

#### do we have the correct number of motifs?
ok( scalar( @motifs ), $f_data->{motif_number} );

#### take the first, and check for passed in stuff...
my $motif = $motifs[ 0 ];
ok( $handle, $motif->factory );
ok( $fingerprint, $motif->fingerprint );
ok( $sequence, $motif->sequence );

my $motif2 = $motifs[ 1 ];
ok( ($handle == $motif2->factory) &&
    ($fingerprint == $motif2->fingerprint ) &&
    ($sequence == $motif2->sequence) );


#### check the repeat stuff
ok( ($m_data->{repeat} eq $motif->repeat)
    && ($m_data2->{repeat} eq $motif2->repeat) );


#### check the seqn_fragment
ok( ($m_data->{seqn_fragment} eq $motif->sequence_fragment) );
ok( ($m_data2->{seqn_fragment} eq $motif2->sequence_fragment) );
ok( not ($motif->sequence_fragment eq $motif2->sequence_fragment) );

#### And the rest
ok( ($m_data->{start_position} eq $motif->start_position ) );
ok( ($m_data->{inter_motif_dist} eq $motif->inter_motif_distance ) );
ok( ($m_data->{initial} eq $motif->initial ) );
ok( ($m_data->{final} eq $motif->final ) );

