#!/usr/local/bin/perl -w

use lib 't' , 'lib';
use strict;
use Test;

BEGIN{ plan tests => 13 }

use Prints::PrintsHandle;

use factory;
use data;

#### Get handle
my $handle = factory;
ok( 1 );

my $data = data::fprint_accession;

##### Instantiation checks. All of the following should work without database access.
my $fprint = fingerprint( $handle, $data->{accession} );

### The fingerprint should have access to the handle via Root
ok( $handle, $fprint->factory );

### And it should return a connection if asked
ok( $fprint->factory->connection->isa( "PG_conn" ) );

### And it should return the same accession that it started with.
ok ( $fprint->accession, $data->{accession} );

##### All of the following requires database access

### Check identifier
ok ( $fprint->identifier, $data->{identifier} );

### Check family title
ok ( $fprint->family_title, $data->{family_title} );

### Number of motifs
ok ( $fprint->motif_number, $data->{motif_number} );

### Documentation
ok( $fprint->family_doc, $data->{family_doc} );

### pseudo
ok( $fprint->pseudo, $data->{pseudo} );

### date
ok( $fprint->date, $data->{date} );

### up-date
ok( $fprint->up_date, $data->{up_date} );

### Parental fingerprint
my $parent = $fprint->parental_fingerprint;
ok( $parent->accession, $data->{parent} );

#### Child fingerprints
my $child_accn = data::fprint_children;

my @child_fingerprints = $parent->child_fingerprint;
my $found_all = 1;

foreach my $i (@$child_accn){
  if( not(  has_fingerprint( $i, @child_fingerprints ) ) ){
    $found_all = 0;
  }
}

ok( $found_all );


sub has_fingerprint{
  my $accession = shift;
  my $fingerprints = shift;

  foreach my $i (@$fingerprints){
    if( $accession eq $i->accession ){
      return 1;
    }
  }
  return 0;
}
