

package Prints::Model::Sql::SqlPrintsHandle;

use strict;
use Exporter;

use vars qw(@ISA);
use base qw(Prints::Model::BasicPrintsHandle Exporter);
use Pg;


use Prints::Model::Sql::SqlFingerprint;
use Prints::Model::Sql::SqlSequence;



sub _initialize{
  my $self = shift;
  my $params = shift;
  ## Extract parameters to pass. Mostly Pg's own defaults are fine
  my $dbname = $self->_getparam( $params, "dbname", "prints_s" );
  my $host = $self->_getparam( $params, "host" );
  my $port = $self->_getparam( $params, "port" );
  my $options = $self->_getparam( $params, "options" );
  my $user = $self->_getparam( $params, "user" );
  my $password = $self->_getparam( $params, "password" );

  $self->{connection}=Pg::connectdb( "$dbname $host $port $options $user $password" );
  $self->SUPER::_initialize( $params );
  return;
}

sub _getparam{
  my $self = shift;
  my $params = shift;
  my $key = shift;
  my $default = shift;
  my $environ = $ENV{uc("PRINTS_PERL_$key")};
  my $value = $params->{$key} || $environ || $default;

  if( defined( $value ) ){
    return "$key=$value";
  }
  else{
    return "";
  }
}

sub connection{
  my $self = shift;

  return $self->{connection};
}

sub _optional_methods{
  return qw{connection};
}

sub create_fingerprint{
  my $self = shift;
  my $params = shift;

  my $fingerprint_accession = $$params[0];

  return Prints::Model::Sql::SqlFingerprint->new
    (
     {
      accession=>$fingerprint_accession,
      factory=>$self->{factory},
     }
    );
}

sub create_sequence{
  my $self = shift;
  my $params = shift;

  my $sequence_accession = $$params[0];
  return Prints::Model::Sql::SqlSequence->new
    (
     {
      accession=>$sequence_accession,
      factory=>$self->{factory},
      }
    );
}




1;
