#
# $Id: Fingerprint.pm,v 1.2 2002/01/03 18:01:44 phillord Exp $
#


package Prints::Model::Fingerprint;

=head1 NAME

  Prints::Model::Fingerprint;

=head1 SYNOPSIS

  TODO

=head1 DESCRIPTION

  Represents a fingerprint

=cut

use Carp;
use Exporter;
use strict;
use Prints::Model::Root;

use vars qw(@ISA);
use base qw(Prints::Model::Root Exporter);


## Expects accesion number as only argument
sub _initialize{
  my $self = shift;
  my $params = shift;

  # take the accession number. Pass up the factory
  $self->{accession} = $params->{accession};
  $self->SUPER::_initialize( $params );
}

=head2 fprint_accn

  Get Set fingerprint accession.

  This will be something like PR00240. Probably Ill have another method
  which will stip of the PR as well.

=cut
sub accession{
  my $self = shift;
  return $self->{accession};
}

=head2 motif

  Get/Set Motif for a given Sequence.
  Will return a reference to any array of Motif objects.
  motif_number will return the number of motifs.

  Parameters as a hash.
  Required parameters
  sequence:- the sequence object.
  motif_number:- the motif which we want to get or set.
  Optional parameters
  motif:- should be either a motif, or an array. Set the motifs.

=cut
sub motif{
  my $self = shift;
  $self->niy();

  ### Do we want something like this in the super class? Probably.
  # my $params = shift;
  #   my $motifs = $params->{motifs};
  #   if( defined( $motifs ) && (!$self->factory()->is_updateable()) ){
  #     croak "Attempt to update a non updateable database";
}

sub motifs{
  my $self = shift;
  my $motif_number = $self->motif_number;
  my $params = shift;
  
  my @return;
  for( my $i = 1;
       $i < $motif_number + 1;
       $i++ ){
    push( @return, $self->motif(
                                {
                                 fingerprint=>$self,
                                 sequence=>$params->{sequence},
                                 motif_number=>$i,
                                 factory=>$self->factory,
                                }
                               ) );
  }
  return @return;
}

sub motif_number{
  my $self = shift;
  $self->niy();
}

=head2 motif

  Get/Set the identifier.
  This will a string like "ADRENRGCA1DR"

=cut
sub identifier{
  my $self = shift;
  $self->niy();
}

=head2 date

  Does perl have a date data type?

=cut
sub date{
  my $self = shift;
  $self->niy();
}


sub up_date{
  my $self = shift;
  $self-niy();
}

=head2 family_title

  A string something like Alpha-1D adrenergic receptor signature

=cut
sub family_title{
  my $self = shift;
  $self->niy();
}

=head2 family_doc

  Dont know what family doc does. It looks like some sort of accession number.
  Perhaps its a link to the text. Should this return the text or what.

=cut
sub family_doc{
}

=head2 category

  Dont know what this is. Again a string.

=cut
sub category{
}

# more strings like the fprint_accn
sub second_accession{
}

# a boolean
sub pseudo{
}

# get the parental fingerprint
sub parental_fingerprint{
}

# get the child fingerprints as an array.
sub child_fingerprint{
}


1;
