use ExtUtils::MakeMaker;




if( -f "t/test-config.pl" ){
  require "t/test-config.pl";
}




WriteMakefile
  (
   'NAME'=>'Prints',
   'dist'=>{COMPRESS=>"gzip", SUFFIX=>"gz"},
   'VERSION'=>'0.3'
  );


print <<INTRO;

PRINTS Perl API

In order to test this API, you need access to a PRINTS_S
installation, either locally or remotely. 

INTRO

#*F = *STDOUT;
open( F, ">t/test-config.pl" );
get_param( \*F, "database", "Enter the name of the database", "prints_s" );
get_param( \*F, "host", "Enter the host machine for the PRINTS_S database", "" );
get_param( \*F, "port", "Enter the port for the PRINTS_S database", "" );
get_param( \*F, "user", "Enter the user name for the database", "" );
get_param( \*F, "password", "Enter the password (Warning! This will be written to file)", "" );
print F "1;\n";

close( F );

sub get_param{
  my $F = shift;
  my $param = shift;
  my $message = shift;
  my $default = $ENV{uc( "PRINTS_PERL_$param" ) } || shift;

  print "$message [$default]: ";
  my $input = <STDIN>;
  chomp $input;
  if( !$input ) {
    $input = $default;
  }

  my $output = '$ENV{PRINTS_PERL_' . uc( $param ) . '}="' . $input . "\";\n";
  print F $output;
  eval $output;
}
