#!/usr/local/bin/perl -w

use lib 't' , 'lib';
use strict;
use Test;

BEGIN{ plan tests => 6}

use Prints::PrintsHandle;

use factory;

#### Create a factory
my $handle = factory;

ok( 1 );

my $data = data::seqn_accession;

##### Instantiation tests. Should require no database access
my $sequence = sequence( $handle, $data->{accession} );
ok( 1 );

### Does it have the correct reference to the handle
ok( $handle, $sequence->factory );

### Does it return the accession we have given
ok ( $sequence->accession, $data->{accession} );

##### Tests which require database access. Identifier correct?
ok ( $sequence->identifier, $data->{identifier} );

#### title
ok ( $sequence->title, $data->{title} );




