#!/usr/local/bin/perl -w

## External libraries
use lib 't' , 'lib';
use strict;
use Test;

BEGIN{ plan tests => 5 }

## API libraries
use Prints::PrintsHandle;
use Prints::Model::BasicPrintsHandle;

## Test libraries
use factory;


### First we want to test whether the BasicPrintsHandle when created,
### and given a factory object in the parameters, returns that factory
### correctly. 
my $hash = 
{ hello=>"goodbye",
  host=>"methionine.sbc.man.ac.uk",
  user=>"lord",
  password=>"pl423793"
};
my $basic_prints_handle = Prints::Model::BasicPrintsHandle->new({factory=>$hash});
my $returned_factory = $basic_prints_handle->{factory};
ok( $hash, $returned_factory );


### Next want to instantiate SqlPrintsHandle. Same test as above
my $sql_prints_handle = Prints::Model::Sql::SqlPrintsHandle->new({factory=>$hash});
$returned_factory = $sql_prints_handle->{factory};
ok( $hash, $returned_factory );

### Have we got a correct connection
ok( $sql_prints_handle->connection->isa( "PG_conn" ) );

#### We are supposed to do all of the above, through the
#### PrintsHandle. See if this works
my $factory = factory();
ok( 1 );

## now make sure that the factory does what it should do...
ok( $factory->connection->isa( "PG_conn" ) );



