package Prints::Model::Sql::SqlFingerprint;

use strict;
use Exporter;

use vars qw(@ISA);
use base qw(Prints::Model::Fingerprint Prints::Model::Sql::SqlRoot Exporter);

use Prints::Model::Sql::SqlMotif;

# This is specific to postgres at the moment. This probably needs fixing at
# the moment.
use Pg;

sub _initialize{
  my $self = shift;

  $self->SUPER::_initialize(@_);
}

sub _lookup{
  my $self = shift;

  if( ! defined( $self->{lookup} ) ){
    my $accession = $self->accession;
    my $result = $self->_exec( "select * from fingerprint where fprint_accn='$accession';" );

    $self->_getfield( $result, "identifier" );
    $self->_getfield( $result, "family_title" );
    $self->_getfield( $result, "family_doc" );
    $self->_getfield( $result, "motifs" );
    $self->_getfield( $result, "date" );
    $self->_getfield( $result, "up_date" );
    $self->_getfield( $result, "category" );
    $self->_getfield( $result, "pseudo" );
    $self->{lookup} = 1;
  }
}


sub identifier{
  my $self = shift;
  $self->_lookup;

  return $self->{identifier};
}

sub family_title{
  my $self = shift;
  $self->_lookup;

  return $self->{family_title};
}

sub family_doc{
  my $self = shift;
  $self->_lookup;

  return $self->{family_doc};
}

sub motif_number{
  my $self = shift;
  $self->_lookup;

  return $self->{motifs};
}

sub category{
  my $self = shift;
  $self->_lookup;

  return $self->{category};
}

sub pseudo{
  my $self = shift;
  $self->_lookup;

  return $self->{pseudo};
}

sub date{
  my $self = shift;
  $self->_lookup;

  return $self->{date};
}

sub up_date{
  my $self = shift;
  $self->_lookup;

  return $self->{up_date};
}

sub motif{
  ## Currently we are just ignoring attempts to update.
  my $self = shift;
  my $param = shift;

  return Prints::Model::Sql::SqlMotif->new
    (
     {
      fingerprint=>$param->{fingerprint},
      sequence=>$param->{sequence},
      motif_number=>$param->{motif_number},
      factory=>$self->{factory},
     }
    );
}

sub parental_fingerprint{
  my $self = shift;
  if( not ( defined($self->{parental_search}) ) ){
    my $accession = $self->accession;
    my $result = $self->_exec( "select * from relation where fprint_one ='$accession';" );

    my $parental_accn =
      $result->getvalue( 0, $result->fnumber( "fprint_two" ) );

    if( defined( $parental_accn ) ){
      $self->{parental_fingerprint} =
        $self->factory->create_fingerprint( $parental_accn );
    }
    $self->{parental_search} = 1;
  }
  return $self->{parental_fingerprint};
}

sub child_fingerprint{
  my $self = shift;
  if( not (defined( $self->{child_search} ) ) ){
    my $accession = $self->accession;
    my $result = $self->_exec( "select * from relation where fprint_two ='$accession';");
    my @child_fingerprints;
    my $no_rows = $result->ntuples;
    for( my $i = 0;
         $i < $no_rows;
         $i++ ){
      my $child_fingerprint =
        $self->factory->create_fingerprint
          ( $result->getvalue( $i, $result->fnumber( "fprint_one" ) ) );
      push( @child_fingerprints,
            $child_fingerprint );
    }
    $self->{child_search} = 1;
    $self->{child_fingerprint}= \@child_fingerprints;
  }

  return $self->{child_fingerprint};
}

1;
