#
# $Id: Sequence.pm,v 1.2 2002/01/03 18:01:43 phillord Exp $
#

package Prints::Model::Sequence;

use Exporter;
use strict;
use Prints::Model::Root;

use vars qw(@ISA);
use base qw(Prints::Model::Root Exporter);

=head1

  This class represents a sequence within the PRINTS_S database.

=head2 Instantiation

  Takes all parameters as a hash.
  Required parameters
  accession:- the accession number of the sequence, which serves as its
  unique identifier in the database.
  Optional Parameters
  None:- other than those provided by the any sub classes.

=cut
sub _initialize{
  my $self = shift;
  my $params = shift;

  $self->{accession} = $params->{accession};
  $self->SUPER::_initialize($params);
}

# returns a accession number for the sequence. This is the swiss prot
# accession number in most cases. Possibly this should be something
# other than a string, maybe a bioperl object. Although any owl codes
# will screw this up.
sub accession{
  my $self = shift;
  return $self->{accession};
}

# returns a identifier.See comments for accession. In a sense this is
# redundant, as it can be derived from the former value (or vice
# versa). However both are stored in the prints_s. It makes sense to
# represent both here, both for convienience (if for instance the
# accession is represented only as a string this translation is not
# trivial), and also if the two conflict with the values in swissprot. 
sub identifier{
}

# this is the sequence title. Also "redundant". See previous comment.
sub title{
}

1;
