#!/usr/bin/perl -w

#use diagnostics -verbose;



use GO::AppHandle;
use GOGraph::Dotty::Dotty;
#use diagnostics;



$dbname="go";
$mysqlhost="localhost";
$apph = GO::AppHandle->connect(-dbname=>$dbname,-dbhost=>$mysqlhost);

#$graph = $apph->get_graph_by_acc( 3673, 2 );
@terms=[];
$terms[ 0 ] = $apph->get_term_by_acc( 7610 );
$terms[ 1 ] = $apph->get_term_by_acc( 16032 );
$terms[ 2 ] = $apph->get_term_by_acc( 3774 );
#$terms[ 3 ] = $apph->get_term_by_acc( 5619 );
#$terms[ 4 ] = $apph->get_term_by_acc( 5566 );
#$terms[ 5 ] = $apph->get_term_by_acc( 30189 );
#$terms[ 6 ] = $apph->get_term_by_acc( 19047 );
#$terms[ 7 ] = $apph->get_term_by_acc( 8047 );

#print $terms[ 2 ]->public_acc;


$graph = $apph->get_graph_by_terms( \@terms, 1 );


$apph->disconnect;

#to_text_output( $graph );
my $graphout = GOGraph::Dotty::Dotty::go_graph_to_graphviz( $graph );


#Dotty::Dotty::graph_to_dot_output ( $graph, *STDOUT );

open( FH, "|dotty -" ) || die "$!";
#print $graphout->as_text();
print FH $graphout->as_text();
close( FH ) || die "$!";

#system( "dot ~/scratch/test.dot > test.dotty" );
#system( "killall lefty" );
#system( "dotty ~/scratch/test.dotty" );




exit( 0 );


sub tab {
    my $tab = shift;
    my $tc = shift || "  ";
    print $tc x $tab;
}



sub to_text_output {
    my $self = shift;
    my ($show_assocs) = @_;

##    my $it = GO::Model::GraphIterator->new({graph=>$self});
    my $it = $self->create_iterator;

    while (my $ni = $it->next_node_instance) {
        my $depth = $ni->depth;
        my $term = $ni->term;
        my $parent_rel = $ni->parent_rel;
	tab($depth, $self->is_focus_node($term) ? "->" : "  ");
	my %th = qw(isa % partof <);
	printf
	  "%2s Term = %s (%s)  // products=%s // $depth\n",
          $ni->parent_rel ? $th{$ni->parent_rel->type} : "",
	  $term->name,
	  $term->public_acc,
	  $term->n_deep_products || 0,
          $depth,
	  ;
	if ($show_assocs && $self->is_focus_node($term)) {
	    my $al = $term->association_list;
	    foreach my $a (@$al) {
		tab $depth;
		printf "\t* %s %s %s\n",
		$a->gene_product->symbol,
		$a->gene_product->full_name,
		$a->gene_product->acc,
		join("; ", map {$_->code} @{$a->evidence_list}),
	    }
	}
    }
    
}


# sub to_dot_output{
#   my $self = shift;
#   my $it = $self->create_iterator;
#   ## Place to store the relationships we have already seen or they
#   ## come out lots of times
#   my %relationships = {};
  
#   local *FH = shift;
  
#   print FH "\ndigraph G {\n";

#   while (my $ni = $it->next_node_instance ){
#     my $term = $ni->term;
#     my $parents = $term->get_parent_terms;

#     foreach my $p (@$parents) {
#       # Have we seen this relationship before
#       $identifier = $p->acc . " " . $term->acc;
#       unless( $relationships{ $identifier } ){
#         dot_node( $p, *FH );
#         print FH " -> ";
#         dot_node( $term, *FH );
#         print FH ";\n";
#         dot_node_label( $term, *FH );
#         $relationships{ $identifier } = 1;
#       }
#     }
#   }

#   print FH  "}\n";
# }


# sub dot_node{
#   my $term = shift;
#   local *FH = shift;
#   my $acc = $term->acc;
#   my $name = $term->name;

#   print FH "$acc";# [label=\"$name\"]";
# }

# sub dot_node_label{
#   my $term = shift;
#   local *FH = shift;
#   my $acc = $term->acc;
#   my $name = $term->name;

#   print FH "$acc [label=\"$name\"];\n";
# }
