#!/usr/bin/perl -w

package GeneOntology::Association::AssociationHandle;

use strict;
use Exporter;
use vars qw(@ISA);
use DBI;

my @ISA = qw{Exporter};
# Fixes fontification}

use GeneOntology::Association::Association;

sub new{
  my $proto = shift;
  my $class = ref($proto) || $proto;
  my $params = shift;
  my $connection = DBI->connect( "dbi:Pg:dbname=goswiss", "", "" );
  my $self = {
              connection=>$connection,
              statements=>{}
             };

  bless $self, $class;
  return $self;
}

sub _prepare_statement{
  my $self = shift;
  my $query = shift;
  my $statements = $self->{statements};

  if( ! defined( $statements->{$query} ) ){
    my $connection = $self->{connection};
    my $statement = $connection->prepare
      ( $query );
    $statements->{$query} = $statement;
  }
}

sub _fetch_statement{
  my $self = shift;
  my $query = shift;
  $self->_prepare_statement($query);

  return $self->{statements}->{$query};
}

sub _connection{
  my $self = shift;
  return $self->{connection};
}


sub _get_association_by_association_id{
  my $self = shift;
  my $id = shift;

  my $association = GeneOntology::Association::Association->new
    ({handle=>$self, id=>$id});

  return $association;
}

sub get_association_by_sequence_identifier{
  my $self = shift;
  my $identifier = uc( shift );

  my $sth = $self->_fetch_statement
    ( "select id from go where sequenceid =
         (select id from sequence where identifier = ? );" );
  $sth->execute( $identifier );
  ## fetch all the results as array of references to arrays
  my $result = $sth->fetchall_arrayref;
  my @association;

  foreach my $row ( @$result ){
    push( @association,
          $self->_get_association_by_association_id( @$row[ 0 ] ) );
  }

  return \@association;
}

sub DESTROY{
  my $self = shift;
  my $statements = $self->{statements};

  foreach my $statement ( values( %$statements ) ){
    $statement->finish();
  }

  $self->_connection->disconnect;
}


