#!/usr/bin/perl -w

package GeneOntology::Association::Association;

use strict;
use Exporter;
use vars qw{@ISA};
use DBI;

my @isa=qw{Exporter};
# fix font}

sub new{
  my $proto = shift;
  my $class = ref($proto) || $proto;
  my $params = shift;
  my $self = {};
  bless $self, $class;
  $self->_initialize( $params );
  return $self;
}

sub _initialize{
  my $self = shift;
  my $params = shift;

  $self->{handle} = $params->{handle};
  $self->{id} = $params->{id};
}

sub _id{
  my $self = shift;
  return $self->{id};
}

sub _lookup{
  my $self = shift;

  if( ! defined( $self->{lookup} ) ){
    my $id = $self->_id;
    my $sth = $self->{handle}
      ->_fetch_statement( "select * from go where id = ?;" );
    $sth->execute(  $id  );
    my $result = $sth->fetchrow_hashref;

    $self->{goid} = $result->{goid};
    $self->{referencedb} = $result->{referencedb};
    $self->{references} = $result->{references};
    $self->{evidence} = $result->{evidence};
    $self->{with} = $result->{with};
    $self->{aspect} = $result->{aspect};

    $self->{lookup} = 1;
  }
}

sub goid{
  my $self = shift;
  $self->_lookup();
  return $self->{goid};
}

sub referencedb{
  my $self = shift;
  $self->_lookup();
  return $self->{referencedb};
}
