#!/usr/bin/perl -w

package GeneOntology::Association::Install;

=head1
  Get database ready

=cut
#use strict;
use DBI;



my $connection = DBI->connect( "dbi:Pg:dbname=goswiss", "", "" );
#$connection->trace( 1 );

my $insert_sequence = $connection->prepare
  ( 'insert into sequence values( ?, ?, ?, ?, ?, ?, ? );' );
my $select_handle = $connection->prepare
  ( "select id from sequence where accession = ?;");
my $insert_go = $connection->prepare
  ( 'insert into go values( ?, ?, ?, ?, ?, ?, ?, ? );' );

my $go_id_counter = 0;
my $seq_id_counter = 0;

print "Inserting relationships between Sequence and Gene Ontology\n";

open( FH, "gene_association.goa" ) || die $!;
#open( FH, "short") || die $!;
while( $line = <FH> ){
  my ($seqdb, $seqacc, $seqid, $not, $goid, $dbref, $evidence,
      $with, $aspect, $seq_title, $synonym, $type, $taxon, $xrefs )
    = split /\t/, $line;

  ### First we need to insert the sequence if it is not yet
  ### available

  ## find sequence id if it exists
  $select_handle->execute( $seqacc );
  my $existing_id = $select_handle->fetchrow_array;
  $select_handle->finish;
  if( ! defined( $existing_id ) ){
    ## New sequence so increase the counter. We do this first so that
    ## subsequent use of this in the GO table is correct. We are
    ## making the implicit assumption here that gene-association.goa
    ## file is SORTED by accession number. If its not we have to use
    ## the select result.
    $seq_id_counter++;

    ## Some of the rows need some additional treatment The taxon row
    ## is of the form "taxon:9999". We just want the last part here.
    my $junk;
    ($junk, $taxon) =  split( /:/, $taxon );
    chomp( $taxon );

    $insert_sequence->execute( $seq_id_counter, $seqdb,
                               $seqacc, $seqid, $synonym, $taxon, $xrefs );
    $insert_sequence->finish;
  }
  ### Now we need to insert the GO association into the database.
  ## First some treatment
  my ($reference_database, $reference_id) = split( /:/, $dbref );
  my $junk;
  ($junk, $goid) = split( /:/, $goid );
  $insert_go->execute( $go_id_counter, $seq_id_counter, $goid,
                       $reference_database, $reference_id,
                       $evidence, $with, $aspect );
  $insert_go->finish;
  $go_id_counter++;

  print "$seqid $goid Complete\n";
}


close( FH );
$connection->disconnect;

print "Database Complete";
