;; $Revision: 1.16 $
;; $Date: 2005/02/04 11:15:13 $

;; This file is not part of Emacs

;; Author: Phillip Lord <p.lord@russet.org.uk>
;; Maintainer: Phillip Lord <p.lord@russet.org.uk>
;; Maintainer (XEmacs): Martin Kuehl (martin.kuehl@gmail.com)
;; Website: http://www.russet.org.uk

;; COPYRIGHT NOTICE
;;
;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA. 

;;; Commentary:
;;
;; Defines a major mode for editing the OWL Concrete Abstract Syntax. 
;; Basically, this is just a bit of font locking. 


(require 'wisent-cowl-wy)

(define-generic-mode 'cowl-mode
  ;; comment-start-finish
  (list (cons "/*" "*/"))
  
  ;; keywords
  (list 
   "Ontology"
   "Namespace"
   "Class"
   "ObjectProperty"
   "domain"
   "inverseOf"
   "owl:Thing"
   "partial"
   "complete"
   "restriction"
   "someValuesFrom"
   "intersectionOf")
  nil
  (list "\\.cowl$")
  nil)

