;; $Revision: $
;; $Date: $

;; This file is not part of Emacs

;; Author: Phillip Lord <p.lord@russet.org.uk>
;; Maintainer: Phillip Lord <p.lord@russet.org.uk>
;; Website: http://www.cs.man.ac.uk

;; COPYRIGHT NOTICE
;;
;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA. 


;;; Commentary:
;;
;; Provides support for the cowl.sty file to auctex. Load this at any
;; time. 

(eval-after-load "tex"
  '(TeX-add-style-hook
    "cowl"
    (lambda ()
      (LaTeX-add-environments "cowl")
      (make-local-variable 'LaTeX-indent-environment-list)
      (add-to-list 'LaTeX-indent-environment-list
                   '("cowl" current-indentation))
      (make-local-variable 'LaTeX-verbatim-regexp)
      (setq LaTeX-verbatim-regexp (concat LaTeX-verbatim-regexp "\\|cowl"))
      (make-local-variable 'font-latex-verbatim-environments)
      ;;(setq font-latex-verbatim-environments
      ;;      (append font-latex-verbatim-environments '("cowl")))
      ;;(font-latex-set-syntactic-keywords)
      )))

(provide 'cowl-auctex)