/*
 *This library is free software; you can redistribute it and/or
 *modify it under the terms of the GNU Lesser General Public
 *License as published by the Free Software Foundation; either
 *version 2.1 of the License, or (at your option) any later version.
 *
 *This library is distributed in the hope that it will be useful,
 *but WITHOUT ANY WARRANTY; without even the implied warranty of
 *MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *Lesser General Public License for more details.
 *
 *You should have received a copy of the GNU Lesser General Public
 *License along with this library; if not, write to the Free Software
 *Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* 
 * This software was written by Phillip Lord (p.lord@hgmp.mrc.ac.uk)
 * whilst at the University of Manchester as a Pfizer post-doctoral 
 * Research Fellow. 
 *
 * The initial code base is copyright by Pfizer, or the University
 * of Manchester. Modifications to the initial code base are copyright
 * of their respective authors, or their employers as appropriate. 
 * Authorship of the modifications may be determined from the ChangeLog
 * placed at the end of this file
 */

package uk.ac.man.bioinf.sequence.complex; // Package name inserted by JPack
import java.util.Arrays;
import java.util.Comparator;


/**
 * ModificationSet.java
 *
 *
 * Created: Mon Feb 28 21:16:56 2000
 *
 * @author Phillip Lord
 * @version $Id: ModificationSet.java,v 1.6 2001/04/11 17:04:43 lord Exp $
 */

class ModificationSet 
{
  // This array should always be sorted!!!
  private Modification[] modifications;
  private int hash = 0;
  private boolean changed = true;
  
  private static Comparator modificationComparator = new Comparator()
  {
    public int compare(Object param1, Object param2) 
    {
      return ((Modification)param1).getName().compareTo( ((Modification)param2).getName() );
    }
    };
  
  ModificationSet()
  {
  }
  
  void setModification()
  {
    modifications = new Modification[ 0 ];
  }
  
  void setModification( Modification modification )
  {
    changed = true;
    modifications = new Modification[ 1 ];
    modifications[ 0 ] = modification;
  }
  
  void setModification( Modification[] modifications )
  {
    changed = true;
    this.modifications = modifications;
    // guarentee that array is sorted. This allows the equals
    // comparison to be done at high speed.
    Arrays.sort( this.modifications, modificationComparator );
  }
  
  boolean containsModification( Modification mod )
  {
    // this takes place in log n time. A hash table would be faster,
    // but the getModifications, equals and hashCode methods will run
    // in something greater than linear time (depending on the load of
    // the hash). Also there is no waste of memory in storage here,
    // where there is in a hash. And for small numbers of
    // modifications the hash function will probably take longer than
    // this search
    return (Arrays.binarySearch( modifications, mod ) > 0);
  }
  
  Modification[] getModifications()
  {
    return modifications;
  }
  
  public boolean equals( Object obj )
  {
    if( !( obj instanceof ModificationSet ) ) return false;
    return Arrays.equals( modifications, ((ModificationSet)obj).modifications);
  }
  
  public int hashCode()
  {
    if( changed ){
      for( int i = 0; i < modifications.length; i++ ){
	hash += modifications[ i ].hashCode();
      }
      changed = false;
    }
    return hash;
  }
} // ModificationSet



/*
 * ChangeLog
 * $Log: ModificationSet.java,v $
 * Revision 1.6  2001/04/11 17:04:43  lord
 * Added License agreements to all code
 *
 * Revision 1.5  2000/11/27 18:14:02  lord
 * Realised that I had not implemented the ComplexSequence. Have now done
 * this and have made quite a few changes to this package as a result
 *
 * Revision 1.4  2000/07/18 12:38:10  lord
 * Import rationalisation
 *
 * Revision 1.3  2000/05/30 16:04:18  lord
 * Have rationalised and sorted all the import statements
 *
 * Revision 1.2  2000/03/01 14:30:46  lord
 * Lots of changes so that this can be generated by a factory
 *
 * Revision 1.1  2000/02/29 11:24:58  lord
 * Initial Checkin
 *
 */
