/*
 *This library is free software; you can redistribute it and/or
 *modify it under the terms of the GNU Lesser General Public
 *License as published by the Free Software Foundation; either
 *version 2.1 of the License, or (at your option) any later version.
 *
 *This library is distributed in the hope that it will be useful,
 *but WITHOUT ANY WARRANTY; without even the implied warranty of
 *MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *Lesser General Public License for more details.
 *
 *You should have received a copy of the GNU Lesser General Public
 *License along with this library; if not, write to the Free Software
 *Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* 
 * This software was written by Phillip Lord (p.lord@hgmp.mrc.ac.uk)
 * whilst at the University of Manchester as a Pfizer post-doctoral 
 * Research Fellow. 
 *
 * The initial code base is copyright by Pfizer, or the University
 * of Manchester. Modifications to the initial code base are copyright
 * of their respective authors, or their employers as appropriate. 
 * Authorship of the modifications may be determined from the ChangeLog
 * placed at the end of this file
 */

package uk.ac.man.bioinf.sequence.complex; // Package name inserted by JPack
import uk.ac.man.bioinf.sequence.SequenceType;


/**
 * ComplexSequenceType.java
 *
 *
 * Created: Tue Feb 29 11:25:27 2000
 *
 * @author Phillip Lord
 * @version $Id: ComplexSequenceType.java,v 1.3 2001/04/11 17:04:43 lord Exp $
 */

public interface ComplexSequenceType extends SequenceType
{
  /**
   * Gets all of the Modifications which are allowable in this
   * sequence type. This should be immutable for a given instance of this.
   * @return the modifications
   */
  public Modification[] getModifications();
  
  /**
   * Is this modification one which is allowable in this sequence
   * type. This should be immutable for a given instance of this.
   * @param mod the modification
   * @return true if the modification is allowable
   */
  public boolean isModification( Modification mod );
  
  /**
   * Are these modifications allowable in this sequence type. This
   * should be immutable.
   * @param mod the modifications
   * @return true if all the modifications are allowable
   */
  public boolean isModification( Modification[] mod );
  
  /**
   * Is this given element allowable in this sequence type. A trivial
   * implementation of this would simply check if the ComplexElement
   * Residue is allowable, and all of the Modifications for this
   * ComplexElement are allowable. However there are other
   * possibilties if for instance not all Residues in a given sequence
   * type are Modifiable by all the allowable modifications
   * @param elem
   * @return
   */
  public boolean isAllowableElement( ComplexElement elem );
  
} // ComplexSequenceType



/*
 * ChangeLog
 * $Log: ComplexSequenceType.java,v $
 * Revision 1.3  2001/04/11 17:04:43  lord
 * Added License agreements to all code
 *
 * Revision 1.2  2000/03/01 20:17:55  lord
 * Lots of changes
 *
 * Revision 1.1  2000/03/01 14:33:08  lord
 * Initial checkin
 *
 */

