/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.bioinf.module;

import java.util.Arrays;
import uk.ac.man.bioinf.module.Module;
import uk.ac.man.bioinf.module.ModuleContext;
import uk.ac.man.bioinf.module.ModuleException;
import uk.ac.man.bioinf.module.ModuleExceptionType;
import uk.ac.man.bioinf.module.ModuleIdentifier;
import uk.ac.man.bioinf.module.ModuleList;

public class ModuleStorageStructure {
    private Module module;
    private Module[] requiredModules;
    private ModuleContext context;
    private Object config;
    private ModuleIdentifier concrete;

    public ModuleStorageStructure() {
    }

    public ModuleStorageStructure(ModuleContext moduleContext) {
        this.context = moduleContext;
    }

    public ModuleStorageStructure(ModuleContext moduleContext, Object object) {
        this.context = moduleContext;
        this.config = object;
    }

    public void setModule(Module module) throws ModuleException {
        if (this.module != null) {
            throw new ModuleException("Module already defined in ModuleStorageStructure (" + this + ")", ModuleExceptionType.MODULE_EXISTS);
        }
        this.module = module;
    }

    public Module getModule() {
        return this.module;
    }

    public void addRequiredModules(Module[] moduleArray) {
        int n = this.requiredModules != null ? this.requiredModules.length : 0;
        int n2 = moduleArray.length;
        Module[] moduleArray2 = new Module[n + n2];
        int n3 = 0;
        while (n3 < n) {
            moduleArray2[n3] = this.requiredModules[n3];
            ++n3;
        }
        int n4 = n;
        while (n4 < n + n2) {
            moduleArray2[n4] = moduleArray[n4 - n];
            ++n4;
        }
        this.requiredModules = moduleArray2;
    }

    public void addRequiredModule(Module module) {
        if (this.requiredModules != null) {
            Module[] moduleArray = new Module[this.requiredModules.length + 1];
            int n = 0;
            while (n < this.requiredModules.length) {
                moduleArray[n] = this.requiredModules[n];
                ++n;
            }
            moduleArray[this.requiredModules.length] = module;
            this.requiredModules = moduleArray;
        } else {
            this.requiredModules = new Module[1];
            this.requiredModules[0] = module;
        }
    }

    public ModuleList getRequiredModules() {
        int n = 0;
        while (n < this.requiredModules.length) {
            if (!this.requiredModules[n].isStarted()) {
                this.requiredModules[n].runStart();
            }
            ++n;
        }
        return new ModuleList(Arrays.asList(this.requiredModules));
    }

    public void setContext(ModuleContext moduleContext) {
        this.context = moduleContext;
    }

    public ModuleContext getContext() {
        return this.context;
    }

    public void setConfig(Object object) {
        this.config = object;
    }

    public Object getConfig() {
        return this.config;
    }

    public void setConcreteIdentifier(ModuleIdentifier moduleIdentifier) {
        this.concrete = moduleIdentifier;
    }

    public ModuleIdentifier getConcreteIdentifier() {
        return this.concrete;
    }
}

