/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.bioinf.module;

import java.util.HashMap;
import java.util.Iterator;
import uk.ac.man.bioinf.module.DefaultModuleContext;
import uk.ac.man.bioinf.module.Module;
import uk.ac.man.bioinf.module.ModuleException;
import uk.ac.man.bioinf.module.ModuleExceptionType;
import uk.ac.man.bioinf.module.ModuleFactoryInstance;
import uk.ac.man.bioinf.module.ModuleIdentifier;
import uk.ac.man.bioinf.module.ModuleList;
import uk.ac.man.bioinf.module.ModuleStorageStructure;

public class DefaultModuleFactoryInstance
implements ModuleFactoryInstance {
    private HashMap mods = new HashMap();
    private HashMap classnames = new HashMap();
    private HashMap moduleNames = new HashMap();

    public Module load(ModuleIdentifier moduleIdentifier) throws ModuleException {
        Module module = ((ModuleStorageStructure)this.mods.get(moduleIdentifier = this.getConcreteIdentifier(moduleIdentifier))).getModule();
        if (module == null) {
            try {
                Class<?> clazz = Class.forName(moduleIdentifier.getClassName());
                module = (Module)clazz.newInstance();
                ModuleStorageStructure moduleStorageStructure = (ModuleStorageStructure)this.mods.get(moduleIdentifier);
                module.setContext(moduleStorageStructure.getContext());
                module.load();
                moduleStorageStructure.setModule(module);
                ModuleIdentifier[] moduleIdentifierArray = module.getRequiredIdentifiers().toArray();
                Module[] moduleArray = new Module[moduleIdentifierArray.length];
                int n = 0;
                while (n < moduleIdentifierArray.length) {
                    if (!this.mods.containsKey(moduleIdentifierArray[n])) {
                        this.addIdentifier(moduleIdentifierArray[n]);
                    }
                    moduleArray[n] = this.load(moduleIdentifierArray[n]);
                    ++n;
                }
                moduleStorageStructure.addRequiredModules(moduleArray);
            }
            catch (NullPointerException nullPointerException) {
                nullPointerException.printStackTrace();
                throw new ModuleException(moduleIdentifier.getClassName(), ModuleExceptionType.MODULE_CLASS_NOT_FOUND);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ModuleException(moduleIdentifier.getClassName(), ModuleExceptionType.MODULE_CLASS_NOT_FOUND);
            }
            catch (InstantiationException instantiationException) {
                throw new ModuleException(moduleIdentifier.getClassName(), ModuleExceptionType.MODULE_INIT_PROBLEM);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ModuleException(moduleIdentifier.getClassName(), ModuleExceptionType.MODULE_INIT_PROBLEM);
            }
        }
        return module;
    }

    private ModuleIdentifier getConcreteIdentifier(ModuleIdentifier moduleIdentifier) {
        if (moduleIdentifier.isInterface()) {
            ModuleStorageStructure moduleStorageStructure = (ModuleStorageStructure)this.mods.get(moduleIdentifier);
            return moduleStorageStructure.getConcreteIdentifier();
        }
        return moduleIdentifier;
    }

    public void addIdentifier(ModuleIdentifier moduleIdentifier) {
        if (this.mods.get(moduleIdentifier) == null) {
            ModuleStorageStructure moduleStorageStructure = new ModuleStorageStructure();
            DefaultModuleContext defaultModuleContext = new DefaultModuleContext(moduleIdentifier, moduleStorageStructure);
            defaultModuleContext.setModuleFactory(this);
            moduleStorageStructure.setContext(defaultModuleContext);
            this.mods.put(moduleIdentifier, moduleStorageStructure);
            this.classnames.put(moduleIdentifier.getClassName(), moduleIdentifier);
            this.moduleNames.put(moduleIdentifier.getModuleName(), moduleIdentifier);
        }
    }

    public void addIdentifier(ModuleIdentifier[] moduleIdentifierArray) {
        int n = 0;
        while (n < moduleIdentifierArray.length) {
            this.addIdentifier(moduleIdentifierArray[n]);
            ++n;
        }
    }

    public ModuleIdentifier resolveModuleName(String string) {
        return (ModuleIdentifier)this.moduleNames.get(string);
    }

    public ModuleIdentifier resolveClassName(String string) {
        return (ModuleIdentifier)this.classnames.get(string);
    }

    public void setModule(ModuleIdentifier moduleIdentifier, Module module) throws ModuleException {
        ModuleStorageStructure moduleStorageStructure = (ModuleStorageStructure)this.mods.get(moduleIdentifier);
        moduleStorageStructure.setModule(module);
    }

    public Module getModule(ModuleIdentifier moduleIdentifier) throws ModuleException {
        Module module = ((ModuleStorageStructure)this.mods.get(moduleIdentifier = this.getConcreteIdentifier(moduleIdentifier))).getModule();
        if (module == null) {
            throw new ModuleException("Attempt to start a module " + moduleIdentifier.getModuleName() + " when it does not exist", ModuleExceptionType.MODULE_DOES_NOT_EXIST);
        }
        if (!module.isStarted()) {
            module.runStart();
        }
        return module;
    }

    public void addRequiredModules(ModuleIdentifier moduleIdentifier, Module[] moduleArray) {
        ModuleStorageStructure moduleStorageStructure = (ModuleStorageStructure)this.mods.get(moduleIdentifier);
        moduleStorageStructure.addRequiredModules(moduleArray);
    }

    public void addRequiredModule(ModuleIdentifier moduleIdentifier, Module module) {
        ModuleStorageStructure moduleStorageStructure = (ModuleStorageStructure)this.mods.get(moduleIdentifier);
        moduleStorageStructure.addRequiredModule(module);
    }

    public ModuleList getRequiredModules(ModuleIdentifier moduleIdentifier) {
        return ((ModuleStorageStructure)this.mods.get(moduleIdentifier)).getRequiredModules();
    }

    public void setConfig(ModuleIdentifier moduleIdentifier, Object object) {
        ModuleStorageStructure moduleStorageStructure = (ModuleStorageStructure)this.mods.get(moduleIdentifier);
        moduleStorageStructure.setConfig(object);
    }

    public Object getConfig(ModuleIdentifier moduleIdentifier) {
        return ((ModuleStorageStructure)this.mods.get(moduleIdentifier)).getConfig();
    }

    public void setConcreteIdentifier(ModuleIdentifier moduleIdentifier, ModuleIdentifier moduleIdentifier2) {
        ModuleStorageStructure moduleStorageStructure = (ModuleStorageStructure)this.mods.get(moduleIdentifier);
        moduleStorageStructure.setConcreteIdentifier(moduleIdentifier2);
    }

    public boolean isModuleAvailable(ModuleIdentifier moduleIdentifier) {
        Module module = ((ModuleStorageStructure)this.mods.get(moduleIdentifier = this.getConcreteIdentifier(moduleIdentifier))).getModule();
        return module != null;
    }

    public void destroy() {
        Iterator iterator = this.mods.values().iterator();
        while (iterator.hasNext()) {
            Module module = ((ModuleStorageStructure)iterator.next()).getModule();
            if (module == null) continue;
            module.destroy();
        }
        this.mods = null;
        this.classnames = null;
        this.moduleNames = null;
    }
}

