/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.bioinf.apps.xml;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.Properties;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import uk.ac.man.bioinf.apps.xml.ConfigNode;
import uk.ac.man.bioinf.apps.xml.XMLBootParserListener;
import uk.ac.man.bioinf.apps.xml.XMLParserFactory;
import uk.ac.man.bioinf.module.AbstractEnumeratedModuleIdentifier;
import uk.ac.man.bioinf.module.GenericModuleIdentifier;
import uk.ac.man.bioinf.module.Module;
import uk.ac.man.bioinf.module.ModuleException;
import uk.ac.man.bioinf.module.ModuleExceptionType;
import uk.ac.man.bioinf.module.ModuleFactoryInstance;
import uk.ac.man.bioinf.module.ModuleIdentifier;

public abstract class XMLBootModule
extends Module {
    private MiniStack pcDataStack = new MiniStack();
    private MiniStack classStack = new MiniStack();
    private MiniStack nameStack = new MiniStack();
    private MiniStack identifierStack = new MiniStack();
    private MiniStack nodeStack = new MiniStack();
    private MiniStack treeStack = new MiniStack();
    private MiniStack valueStack = new MiniStack();
    private MiniStack valueLastStack = new MiniStack();
    private MiniStack paramNameStack = new MiniStack();
    private boolean identifierConcrete = false;
    private boolean readRequired = true;
    private Properties configProperties;
    private ConfigNode configTree;
    private Object[] configObject;
    private String provideName;
    static /* synthetic */ Class class$uk$ac$man$bioinf$apps$xml$DefaultXMLParser;

    public void characters(String string) {
        this.pcDataStack.push(string);
    }

    public void classEnd() {
        this.classStack.push(this.pcDataStack.pop());
    }

    public void nameEnd() {
        this.nameStack.push(this.pcDataStack.pop());
        this.valueLastStack.push(Boolean.FALSE);
    }

    public void paramnameEnd() {
        this.paramNameStack.push(this.pcDataStack.pop());
    }

    public void identifierStart(Attributes attributes) {
        this.identifierConcrete = attributes.getValue("concrete") != null ? attributes.getValue("concrete").equals("true") : true;
    }

    public void enumerationEnd() {
        try {
            ModuleIdentifier[] moduleIdentifierArray = AbstractEnumeratedModuleIdentifier.getAllIdentifiers(Class.forName((String)this.classStack.pop()));
            this.getContext().getModuleFactory().addIdentifier(moduleIdentifierArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public void genericEnd() {
        GenericModuleIdentifier genericModuleIdentifier = new GenericModuleIdentifier((String)this.classStack.pop(), (String)this.nameStack.pop(), !this.identifierConcrete);
        this.getContext().getModuleFactory().addIdentifier(genericModuleIdentifier);
    }

    public void startEnd() {
        String string = (String)this.nameStack.pop();
        try {
            this.getContext().getModuleFactory().getModule(this.getContext().getModuleFactory().resolveModuleName(string));
        }
        catch (ModuleException moduleException) {
            moduleException.printStackTrace();
        }
    }

    public void loadEnd() throws SAXException {
        try {
            String string = (String)this.nameStack.pop();
            ModuleIdentifier moduleIdentifier = this.getContext().getModuleFactory().resolveModuleName(string);
            if (moduleIdentifier == null) {
                throw new ModuleException("Could not resolve name " + string, ModuleExceptionType.MODULE_RESOLVE_FAIL);
            }
            this.getContext().getModuleFactory().load(moduleIdentifier);
        }
        catch (ModuleException moduleException) {
            moduleException.printStackTrace();
        }
    }

    public void readStart(Attributes attributes) {
        this.readRequired = attributes.getValue("required") != null ? attributes.getValue("required").equals("true") : true;
    }

    public void readEnd() throws SAXException {
        String string = (String)this.pcDataStack.pop();
        this.parseResource(string, this.readRequired);
    }

    public void valueEnd() {
        this.valueStack.push(this.pcDataStack.pop());
        this.valueLastStack.push(Boolean.TRUE);
    }

    public void paramEnd() {
        this.configProperties.setProperty((String)this.paramNameStack.pop(), (Boolean)this.valueLastStack.pop() != false ? "VAL:" + this.valueStack.pop() : "MOD:" + this.nameStack.pop());
    }

    public void propertiesStart() {
        this.configProperties = this.configObject[0] == null ? new Properties() : (Properties)this.configObject[0];
    }

    public void propertiesEnd() {
        this.configObject[0] = this.configProperties;
        this.configProperties = null;
    }

    public void provideEnd() {
        this.provideName = (String)this.nameStack.pop();
    }

    public void configStart(Attributes attributes) {
        ModuleIdentifier moduleIdentifier;
        String string = attributes.getValue("mode");
        if ((string == null || string.equals("add")) && (moduleIdentifier = this.getContext().getModuleFactory().resolveModuleName((String)this.nameStack.peek())) != null) {
            this.configObject = (Object[])this.getContext().getModuleFactory().getConfig(moduleIdentifier);
        }
        if (this.configObject == null) {
            this.configObject = new Object[2];
        }
    }

    public void moduleEnd() {
        ModuleFactoryInstance moduleFactoryInstance = this.getContext().getModuleFactory();
        ModuleIdentifier moduleIdentifier = moduleFactoryInstance.resolveModuleName((String)this.nameStack.pop());
        if (this.provideName != null) {
            moduleFactoryInstance.setConcreteIdentifier(moduleIdentifier, moduleFactoryInstance.resolveModuleName(this.provideName));
            this.provideName = null;
        }
        this.getContext().getModuleFactory().setConfig(moduleIdentifier, this.configObject);
        this.configObject = null;
    }

    public void treeStart() {
        this.configTree = this.configObject[1] == null ? new ConfigNode() : (ConfigNode)this.configObject[1];
    }

    public void nodeStart() {
        this.nodeStack.push(new ConfigNode());
    }

    public void nodeEnd() {
        ConfigNode configNode = (ConfigNode)this.nodeStack.pop();
        if (((Boolean)this.valueLastStack.pop()).booleanValue()) {
            configNode.setData((String)this.valueStack.pop());
        } else {
            configNode.setData(this.getContext().resolveModuleName((String)this.nameStack.pop()));
        }
        if (this.nodeStack.peek() == null) {
            this.configTree.addChildNode(configNode);
        } else {
            ((ConfigNode)this.nodeStack.peek()).addChildNode(configNode);
        }
    }

    public void treeEnd() {
        this.configObject[1] = this.configTree;
        this.configTree = null;
    }

    public void load() throws ModuleException {
        try {
            this.parseResource(this.fetchMainBootName(), true);
            this.paramNameStack = null;
            this.valueLastStack = null;
            this.valueStack = null;
            this.treeStack = null;
            this.nodeStack = null;
            this.identifierStack = null;
            this.nameStack = null;
            this.classStack = null;
            this.pcDataStack = null;
            this.configObject = null;
            this.configTree = null;
            this.configProperties = null;
        }
        catch (SAXException sAXException) {
            throw new ModuleException("Problem parsing file ", ModuleExceptionType.MODULE_INIT_PROBLEM, sAXException);
        }
    }

    public void parseResource(String string, boolean bl) throws SAXException {
        try {
            this.parseStream(this.resolveXMLLoadName(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (bl) {
                throw new SAXException("IO Problem with file " + string, fileNotFoundException);
            }
        }
        catch (IOException iOException) {
            throw new SAXException("IO Problem with file " + string, iOException);
        }
    }

    public void parseStream(InputStream inputStream) throws IOException, SAXException {
        XMLReader xMLReader = this.getXMLParser();
        XMLBootParserListener xMLBootParserListener = new XMLBootParserListener(this);
        xMLReader.setContentHandler(xMLBootParserListener);
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId(this.fetchModuleSystemIdentifier());
        xMLReader.parse(inputSource);
    }

    public String getVersion() {
        return "$Id: XMLBootModule.java,v 1.21 2002/03/08 17:44:44 lord Exp $";
    }

    private XMLReader getXMLParser() {
        try {
            XMLParserFactory xMLParserFactory = (XMLParserFactory)Class.forName(this.getXMLParserClass()).newInstance();
            return xMLParserFactory.getXMLParser();
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected String getXMLParserClass() {
        return (class$uk$ac$man$bioinf$apps$xml$DefaultXMLParser == null ? (class$uk$ac$man$bioinf$apps$xml$DefaultXMLParser = XMLBootModule.class$("uk.ac.man.bioinf.apps.xml.DefaultXMLParser")) : class$uk$ac$man$bioinf$apps$xml$DefaultXMLParser).getName();
    }

    public abstract String fetchMainBootName();

    public abstract String fetchModuleSystemIdentifier();

    public abstract InputStream resolveXMLLoadName(String var1) throws IOException;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class MiniStack {
        private LinkedList list = new LinkedList();

        public void push(Object object) {
            this.list.addFirst(object);
        }

        public Object peek() {
            if (this.list.size() == 0) {
                return null;
            }
            return this.list.getFirst();
        }

        public Object pop() {
            if (this.list.size() == 0) {
                return null;
            }
            return this.list.removeFirst();
        }
    }
}

