/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.bioinf.gui.viewer.plaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import uk.ac.man.bioinf.debug.Debug;
import uk.ac.man.bioinf.gui.viewer.AlignmentSelectionModel;
import uk.ac.man.bioinf.gui.viewer.AlignmentSelectionRenderer;
import uk.ac.man.bioinf.gui.viewer.AlignmentViewerCellRenderer;
import uk.ac.man.bioinf.gui.viewer.FastAlignmentViewerCellRenderer;
import uk.ac.man.bioinf.gui.viewer.JAlignmentViewer;
import uk.ac.man.bioinf.gui.viewer.plaf.AlignmentViewerUI;
import uk.ac.man.bioinf.sequence.Element;
import uk.ac.man.bioinf.sequence.Sequences;
import uk.ac.man.bioinf.sequence.alignment.GappedSequence;
import uk.ac.man.bioinf.sequence.alignment.NoGapAtThisPositionException;
import uk.ac.man.bioinf.sequence.alignment.SequenceAlignment;
import uk.ac.man.bioinf.sequence.alignment.event.AlignmentVetoException;
import uk.ac.man.bioinf.sequence.event.SequenceVetoException;
import uk.ac.man.bioinf.sequence.geom.SequenceAlignmentPoint;
import uk.ac.man.bioinf.sequence.geom.SequenceAlignmentRectangle;

public class BasicAlignmentViewerUI
extends AlignmentViewerUI
implements PropertyChangeListener,
MouseInputListener {
    private CellRendererPane rendererPane;
    private JAlignmentViewer viewer;
    private int cellWidth;
    private int cellHeight;
    private AlignmentViewerCellRenderer renderer;
    private FastAlignmentViewerCellRenderer fastRenderer;
    private AlignmentSelectionRenderer selectionRenderer;
    private SequenceAlignment alignment;
    private SequenceAlignmentPoint cursorLocation = new SequenceAlignmentPoint();
    private AlignmentSelectionModel selectionModel;
    private boolean selectingToggle = false;
    private SequenceAlignmentPoint rendererLocation = new SequenceAlignmentPoint();
    private SequenceAlignmentRectangle seqRect = new SequenceAlignmentRectangle();
    private SequenceAlignmentPoint loc = new SequenceAlignmentPoint(0, 0);
    private Rectangle blinkedCursor = new Rectangle();
    private SequenceAlignmentPoint cursorBlinkPoint;
    private boolean blinkOn = false;
    private CursorBlinkThread cursorThread;
    private SequenceAlignmentPoint originalSequencePoint = null;
    private SequenceAlignmentPoint currentSequencePoint = null;
    private int originalMouseY = 0;
    private SequenceAlignmentPoint lastExtendedSelectionPoint = new SequenceAlignmentPoint();

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicAlignmentViewerUI();
    }

    public void installUI(JComponent jComponent) {
        this.rendererPane = new CellRendererPane();
        jComponent.add(this.rendererPane);
        this.viewer = (JAlignmentViewer)jComponent;
        this.cellWidth = this.viewer.getCellWidth();
        this.cellHeight = this.viewer.getCellHeight();
        this.renderer = this.viewer.getCellRenderer();
        this.fastRenderer = this.viewer.getFastCellRenderer();
        this.selectionRenderer = this.viewer.getAlignmentSelectionRenderer();
        this.alignment = this.viewer.getSequenceAlignment();
        this.selectionModel = this.viewer.getSelectionModel();
        this.installListeners();
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallListeners();
    }

    public void installListeners() {
        this.viewer.addPropertyChangeListener(this);
        this.installKeyboardActions(this.viewer);
        this.viewer.addMouseListener(this);
        this.viewer.addMouseMotionListener(this);
        this.viewer.addPropertyChangeListener(this);
        this.viewer.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                BasicAlignmentViewerUI.this.viewer.repaint();
            }

            public void focusLost(FocusEvent focusEvent) {
                BasicAlignmentViewerUI.this.viewer.repaint();
            }
        });
        this.viewer.addCursorChangeListener(new PointListener());
    }

    public void uninstallListeners() {
        this.viewer.removePropertyChangeListener(this);
        this.viewer.removeMouseListener(this);
        this.viewer.removeMouseMotionListener(this);
    }

    public Rectangle paintFocusRect(Graphics graphics, Rectangle rectangle) {
        graphics.setColor(Color.black);
        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
        --rectangle.x;
        --rectangle.y;
        rectangle.height -= 2;
        rectangle.width -= 2;
        return rectangle;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Rectangle rectangle = graphics.getClipBounds();
        if (jComponent.hasFocus()) {
            rectangle = this.paintFocusRect(graphics, rectangle);
        }
        this.paintCells(graphics, jComponent);
        this.paintSelection(graphics, jComponent);
    }

    protected void paintCells(Graphics graphics, JComponent jComponent) {
        Rectangle rectangle = graphics.getClipBounds();
        int n = this.getSequencePointAtPoint(rectangle.x, rectangle.y).getY() - 1;
        n = n < 1 ? 1 : n;
        int n2 = this.getSequencePointAtPoint(rectangle.x, rectangle.y).getX() - 1;
        n2 = n2 < 1 ? 1 : n2;
        int n3 = this.getSequencePointAtPoint(rectangle.x + rectangle.width, rectangle.y).getX() + 1;
        int n4 = this.getSequencePointAtPoint(rectangle.x, rectangle.y + rectangle.height).getY() + 1;
        int n5 = this.cellHeight * (n - 1) + jComponent.getInsets().top;
        int n6 = n;
        while (n6 < n4) {
            int n7;
            int n8 = n2;
            int n9 = n3;
            if (n6 >= this.alignment.getNumberSequences() + 1) {
                n8 = n3;
            } else {
                n7 = this.alignment.getInset(n6) + 1;
                if (n2 < n7) {
                    n8 = n7;
                }
                if (n3 > (n7 = this.alignment.getInset(n6) + this.alignment.getSequenceAt(n6).getGappedLength() + 1)) {
                    n9 = n7;
                }
            }
            n7 = n2;
            while (n7 < n8 - 1) {
                this.rendererLocation.setLocation(n7, n6);
                this.renderCell(graphics, (n7 - 1) * this.cellWidth, n5, this.cellWidth, this.cellHeight, rectangle, this.rendererLocation, null);
                ++n7;
            }
            int n10 = n8;
            while (n10 < n9) {
                this.rendererLocation.setLocation(n10, n6);
                Element element = this.alignment.getSequenceAt(n6).getGappedElementAt(n10 - this.alignment.getInset(n6));
                this.renderCell(graphics, (n10 - 1) * this.cellWidth, n5, this.cellWidth, this.cellHeight, rectangle, this.rendererLocation, element);
                ++n10;
            }
            int n11 = n9 + 1;
            while (n11 < n3) {
                this.rendererLocation.setLocation(n11, n6);
                this.renderCell(graphics, (n11 - 1) * this.cellWidth, n5, this.cellWidth, this.cellHeight, rectangle, this.rendererLocation, null);
                ++n11;
            }
            n5 += this.cellHeight;
            ++n6;
        }
    }

    protected void paintSelection(Graphics graphics, JComponent jComponent) {
        Rectangle rectangle = graphics.getClipBounds();
        SequenceAlignmentRectangle sequenceAlignmentRectangle = this.getSequenceAlignmentRectangleAtRectangle(rectangle);
        int n = 0;
        while (n < this.selectionModel.getNumberSelections()) {
            SequenceAlignmentRectangle sequenceAlignmentRectangle2 = this.selectionModel.getSelectionAt(n);
            Point point = this.getPointAtSequencePoint(sequenceAlignmentRectangle2.getX(), sequenceAlignmentRectangle2.getY());
            Point point2 = this.getPointAtSequencePoint(sequenceAlignmentRectangle2.getWidth() + sequenceAlignmentRectangle2.getX(), sequenceAlignmentRectangle2.getHeight() + sequenceAlignmentRectangle2.getY());
            this.selectionRenderer.renderAlignmentSelection(graphics, point.x, point.y, point2.x - point.x, point2.y - point.y, this.viewer, sequenceAlignmentRectangle2);
            ++n;
        }
    }

    protected void repaint(SequenceAlignmentPoint sequenceAlignmentPoint) {
        this.viewer.repaint(this.getCellBounds(sequenceAlignmentPoint));
    }

    protected void paintImmediately(SequenceAlignmentPoint sequenceAlignmentPoint) {
        this.viewer.paintImmediately(this.getCellBounds(sequenceAlignmentPoint));
    }

    protected void renderCell(Graphics graphics, int n, int n2, int n3, int n4, Rectangle rectangle, SequenceAlignmentPoint sequenceAlignmentPoint, Element element) {
        Color color = this.viewer.getColorMap().getColorAt(this.alignment, element, sequenceAlignmentPoint);
        boolean bl = this.selectionModel.isPointSelected(sequenceAlignmentPoint);
        boolean bl2 = this.viewer.hasFocus();
        boolean bl3 = sequenceAlignmentPoint.equals((Object)this.cursorLocation);
        if (this.renderer == null) {
            this.fastRenderer.renderAlignmentViewerCell(graphics, n, n2, n3, n4, this.viewer, element, sequenceAlignmentPoint, color, bl, bl2, bl3);
        } else {
            Component component = this.renderer.getAlignmentViewerCellRendererComponent(this.viewer, element, sequenceAlignmentPoint, color, bl, bl2, bl3);
            this.rendererPane.paintComponent(graphics, component, this.viewer, n, n2, n3, n4, true);
        }
        if (this.getBlinkOn() && sequenceAlignmentPoint.equals((Object)this.cursorBlinkPoint)) {
            graphics.setXORMode(Color.white);
            graphics.fillRect(n, n2, n3, n4);
            graphics.setPaintMode();
        }
    }

    public SequenceAlignmentRectangle getSequenceAlignmentRectangleAtRectangle(Rectangle rectangle) {
        this.seqRect.setLocation(this.getSequencePointAtPoint((int)rectangle.getX(), (int)rectangle.getY()));
        SequenceAlignmentPoint sequenceAlignmentPoint = this.getSequencePointAtPoint((int)(rectangle.getX() + rectangle.getWidth()), (int)(rectangle.getY() + rectangle.getHeight()));
        this.seqRect.setSize(sequenceAlignmentPoint.getX() - this.seqRect.getX(), sequenceAlignmentPoint.getY() - this.seqRect.getY());
        return this.seqRect;
    }

    public SequenceAlignmentPoint getSequencePointAtPoint(int n, int n2) {
        int n3 = n / this.cellWidth + 1;
        int n4 = n2 / this.cellHeight + 1;
        this.loc.setLocation(n3, n4);
        return this.loc;
    }

    public Point getPointAtSequencePoint(int n, int n2) {
        return new Point((n - 1) * this.cellWidth, (n2 - 1) * this.cellHeight);
    }

    public Point getPointAtSequencePoint(SequenceAlignmentPoint sequenceAlignmentPoint) {
        return this.getPointAtSequencePoint(sequenceAlignmentPoint.getX(), sequenceAlignmentPoint.getY());
    }

    public Rectangle getCellBounds(SequenceAlignmentPoint sequenceAlignmentPoint) {
        return this.getCellBounds(sequenceAlignmentPoint, null);
    }

    public Rectangle getCellBounds(SequenceAlignmentPoint sequenceAlignmentPoint, Rectangle rectangle) {
        if (rectangle == null) {
            rectangle = new Rectangle();
        }
        Point point = this.getPointAtSequencePoint(sequenceAlignmentPoint);
        rectangle.setLocation(point.x, point.y);
        rectangle.setSize(this.cellWidth, this.cellHeight);
        return rectangle;
    }

    private synchronized void setBlinkOn(boolean bl) {
        this.blinkOn = bl;
    }

    private boolean getBlinkOn() {
        return this.blinkOn;
    }

    public synchronized void setCursorBlink() {
        if (this.cursorThread == null) {
            this.cursorThread = new CursorBlinkThread();
            this.cursorThread.start();
        }
        SequenceAlignmentPoint sequenceAlignmentPoint = this.cursorBlinkPoint;
        this.cursorBlinkPoint = this.viewer.getCursorModel().getPoint();
        if (this.getBlinkOn()) {
            this.cursorThread.interrupt();
            this.paintImmediately(sequenceAlignmentPoint);
        }
        this.getCellBounds(this.cursorBlinkPoint, this.blinkedCursor);
        this.setBlinkOn(true);
        this.repaint(this.cursorBlinkPoint);
        this.cursorThread.notifyImpl();
    }

    public synchronized void unsetCursorBlink() {
        this.setBlinkOn(false);
        this.paintImmediately(this.cursorBlinkPoint);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("cellHeight")) {
            Rectangle rectangle = this.viewer.getVisibleRect();
            SequenceAlignmentPoint sequenceAlignmentPoint = this.getSequencePointAtPoint(rectangle.getLocation());
            this.cellHeight = (Integer)propertyChangeEvent.getNewValue();
            Point point = this.getPointAtSequencePoint(sequenceAlignmentPoint);
            rectangle.setLocation(point);
            this.viewer.scrollRectToVisible(rectangle);
        } else if (propertyChangeEvent.getPropertyName().equals("cellWidth")) {
            Rectangle rectangle = this.viewer.getVisibleRect();
            SequenceAlignmentPoint sequenceAlignmentPoint = this.getSequencePointAtPoint(rectangle.getLocation());
            this.cellWidth = (Integer)propertyChangeEvent.getNewValue();
            Point point = this.getPointAtSequencePoint(sequenceAlignmentPoint);
            rectangle.setLocation(point);
            this.viewer.scrollRectToVisible(rectangle);
        } else if (propertyChangeEvent.getPropertyName().equals("fastCellRenderer")) {
            this.fastRenderer = (FastAlignmentViewerCellRenderer)propertyChangeEvent.getNewValue();
        } else if (propertyChangeEvent.getPropertyName().equals("cellRenderer")) {
            this.renderer = (AlignmentViewerCellRenderer)propertyChangeEvent.getNewValue();
        } else if (propertyChangeEvent.getPropertyName().equals("alignmentSelectionRenderer")) {
            this.selectionRenderer = (AlignmentSelectionRenderer)propertyChangeEvent.getNewValue();
        } else if (propertyChangeEvent.getPropertyName().equals("sequenceAlignment")) {
            this.alignment = (SequenceAlignment)propertyChangeEvent.getNewValue();
        } else if (propertyChangeEvent.getPropertyName().equals("alignmentSelectionModel")) {
            this.selectionModel = (AlignmentSelectionModel)propertyChangeEvent.getNewValue();
        } else if (propertyChangeEvent.getPropertyName().equals("readonly")) {
            if (((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                this.viewer.removeMouseMotionListener(this);
            } else {
                this.viewer.addMouseMotionListener(this);
            }
        }
    }

    protected void installKeyboardActions(JAlignmentViewer jAlignmentViewer) {
        jAlignmentViewer.registerKeyboardAction(new SelectionToggler(), KeyStroke.getKeyStroke(10, 0), 2);
        jAlignmentViewer.registerKeyboardAction(new SelectionClearer(), KeyStroke.getKeyStroke(8, 0), 2);
        jAlignmentViewer.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    BasicAlignmentViewerUI.this.viewer.insertGapsAtCursor(1);
                }
                catch (SequenceVetoException sequenceVetoException) {
                    Debug.both((Object)this, (String)"JAlignmentViewer: Can't insert gap - it was vetoed!", (Throwable)sequenceVetoException);
                }
                catch (AlignmentVetoException alignmentVetoException) {
                    Debug.both((Object)this, (String)"JAlignmentViewer: Can't insert gap - it was vetoed!", (Throwable)alignmentVetoException);
                }
            }
        }, KeyStroke.getKeyStroke(32, 0), 2);
        jAlignmentViewer.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    BasicAlignmentViewerUI.this.viewer.deleteGapsAtCursor(1);
                }
                catch (SequenceVetoException sequenceVetoException) {
                    Debug.both((Object)this, (String)"JAlignmentViewer: Can't delete gap - it was vetoed!", (Throwable)sequenceVetoException);
                }
                catch (AlignmentVetoException alignmentVetoException) {
                    Debug.both((Object)this, (String)"JAlignmentViewer: Can't delete gap - it was vetoed!", (Throwable)alignmentVetoException);
                }
            }
        }, KeyStroke.getKeyStroke(127, 0), 2);
        this.registerKey(39, 3);
        this.registerKey(37, 4);
        this.registerKey(40, 2);
        this.registerKey(38, 1);
        this.registerKey("KP_RIGHT", 3);
        this.registerKey("KP_LEFT", 4);
        this.registerKey("KP_DOWN", 2);
        this.registerKey("KP_UP", 1);
    }

    protected void registerKey(String string, int n) {
        this.viewer.registerKeyboardAction(new KeyScroller(this.viewer, n), KeyStroke.getKeyStroke(string), 2);
    }

    protected void registerKey(int n, int n2) {
        this.viewer.registerKeyboardAction(new KeyScroller(this.viewer, n2), KeyStroke.getKeyStroke(n, 0), 2);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.viewer.moveCursor(this.getSequencePointAtPoint(mouseEvent.getPoint()));
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 8) == 8) {
            if (!this.selectionModel.isSelecting()) {
                this.selectionModel.clearSelection();
            }
            this.selectionModel.extendSelection(new SequenceAlignmentPoint(this.getSequencePointAtPoint(mouseEvent.getX(), mouseEvent.getY())));
            this.lastExtendedSelectionPoint.setLocation(this.getSequencePointAtPoint(mouseEvent.getX(), mouseEvent.getY()));
        } else {
            this.originalSequencePoint = new SequenceAlignmentPoint(this.getSequencePointAtPoint(mouseEvent.getX(), mouseEvent.getY()));
            this.originalMouseY = mouseEvent.getY();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 8) == 8) {
            this.selectionModel.stopSelection(new SequenceAlignmentPoint(this.getSequencePointAtPoint(mouseEvent.getX(), mouseEvent.getY())));
        } else {
            if (this.currentSequencePoint != null) {
                this.viewer.moveCursor(this.currentSequencePoint);
            }
            this.originalSequencePoint = null;
            this.originalMouseY = 0;
            this.currentSequencePoint = null;
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 8) == 8) {
            SequenceAlignmentPoint sequenceAlignmentPoint = this.getSequencePointAtPoint(mouseEvent.getX(), mouseEvent.getY());
            if (!sequenceAlignmentPoint.equals((Object)this.lastExtendedSelectionPoint)) {
                this.selectionModel.extendSelection(new SequenceAlignmentPoint(sequenceAlignmentPoint));
                this.lastExtendedSelectionPoint.setLocation(sequenceAlignmentPoint);
            }
        } else if (this.viewer.contains(mouseEvent.getPoint()) || this.originalSequencePoint != null) {
            this.currentSequencePoint = new SequenceAlignmentPoint(this.getSequencePointAtPoint(mouseEvent.getX(), this.originalMouseY));
            int n = this.currentSequencePoint.getX() - this.originalSequencePoint.getX();
            if (n == 0) {
                return;
            }
            if (n > 0) {
                try {
                    this.viewer.insertGapsAt(this.originalSequencePoint, n);
                    this.originalSequencePoint = new SequenceAlignmentPoint(this.currentSequencePoint);
                }
                catch (SequenceVetoException sequenceVetoException) {
                    Debug.both((Object)this, (String)"Cannot insert a gap here - it was vetoed!", (Throwable)sequenceVetoException);
                }
                catch (AlignmentVetoException alignmentVetoException) {
                    Debug.both((Object)this, (String)"Cannot insert a gap here - it was vetoed!", (Throwable)alignmentVetoException);
                }
            } else if (n < 0) {
                try {
                    int n2 = Sequences.getNumberGapsUpstreamFrom((int)(this.currentSequencePoint.getX() - this.alignment.getInset(this.originalSequencePoint.getY())), (GappedSequence)this.alignment.getSequenceAt(this.originalSequencePoint.getY()));
                    if (this.currentSequencePoint.getX() < this.alignment.getInset(this.originalSequencePoint.getY()) + 1 && -n < this.alignment.getInset(this.originalSequencePoint.getY()) + 1 || n2 > -n) {
                        this.viewer.deleteGapsAt(this.currentSequencePoint.getX(), this.originalSequencePoint.getY(), -n);
                    } else {
                        this.viewer.deleteGapsAt(this.currentSequencePoint.getX(), this.originalSequencePoint.getY(), n2);
                    }
                    if (n2 != 0) {
                        this.originalSequencePoint = new SequenceAlignmentPoint(this.currentSequencePoint);
                    }
                }
                catch (NoGapAtThisPositionException noGapAtThisPositionException) {
                    Debug.both((Object)this, (String)"Cannot remove a gap here!", (Throwable)noGapAtThisPositionException);
                }
                catch (SequenceVetoException sequenceVetoException) {
                    Debug.both((Object)this, (String)"Cannot remove a gap here - it was vetoed!", (Throwable)sequenceVetoException);
                }
                catch (AlignmentVetoException alignmentVetoException) {
                    Debug.both((Object)this, (String)"Cannot remove a gap here - it was vetoed!", (Throwable)alignmentVetoException);
                }
            } else {
                return;
            }
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public class KeyScroller
    implements ActionListener {
        private JAlignmentViewer viewer;
        private int direction;
        public static final int UP = 1;
        public static final int DOWN = 2;
        public static final int RIGHT = 3;
        public static final int LEFT = 4;

        public KeyScroller(JAlignmentViewer jAlignmentViewer, int n) {
            this.viewer = jAlignmentViewer;
            this.direction = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            switch (this.direction) {
                case 1: {
                    this.viewer.moveCursorUp(1);
                    break;
                }
                case 2: {
                    this.viewer.moveCursorDown(1);
                    break;
                }
                case 3: {
                    this.viewer.moveCursorRight(1);
                    break;
                }
                case 4: {
                    this.viewer.moveCursorLeft(1);
                }
            }
        }
    }

    public class SelectionToggler
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (BasicAlignmentViewerUI.this.selectingToggle) {
                BasicAlignmentViewerUI.this.selectingToggle = false;
            } else {
                BasicAlignmentViewerUI.this.selectingToggle = true;
                BasicAlignmentViewerUI.this.viewer.extendSelection(BasicAlignmentViewerUI.this.viewer.getPoint());
            }
        }
    }

    public class SelectionClearer
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            BasicAlignmentViewerUI.this.viewer.clearSelection();
            BasicAlignmentViewerUI.this.selectingToggle = false;
        }
    }

    public class PointListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            BasicAlignmentViewerUI.this.cursorLocation = BasicAlignmentViewerUI.this.viewer.getPoint();
            if (BasicAlignmentViewerUI.this.selectingToggle) {
                BasicAlignmentViewerUI.this.viewer.extendSelection(BasicAlignmentViewerUI.this.viewer.getPoint());
            }
            BasicAlignmentViewerUI.this.setCursorBlink();
        }
    }

    class CursorBlinkThread
    extends Thread {
        CursorBlinkThread() {
        }

        public void run() {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(75L);
                        BasicAlignmentViewerUI.this.unsetCursorBlink();
                        this.waitImpl();
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    continue;
                }
                break;
            }
        }

        public synchronized void waitImpl() throws InterruptedException {
            this.wait();
        }

        public synchronized void notifyImpl() {
            this.notify();
        }
    }
}

