/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.bioinf.gui.viewer;

import java.awt.Color;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import uk.ac.man.bioinf.gui.viewer.BorderFastAlignmentViewerCellRenderer;
import uk.ac.man.bioinf.gui.viewer.ColorFastAlignmentViewerCellRenderer;
import uk.ac.man.bioinf.gui.viewer.FastAlignmentViewerCellRenderer;
import uk.ac.man.bioinf.gui.viewer.JAlignmentViewer;
import uk.ac.man.bioinf.gui.viewer.TextFastAlignmentViewerCellRenderer;
import uk.ac.man.bioinf.sequence.Element;
import uk.ac.man.bioinf.sequence.geom.SequenceAlignmentPoint;

public class MultiplexerFastAlignmentViewerCellRenderer
implements FastAlignmentViewerCellRenderer,
PropertyChangeListener {
    private JAlignmentViewer viewer;
    private ColorFastAlignmentViewerCellRenderer color;
    private BorderFastAlignmentViewerCellRenderer border;
    private TextFastAlignmentViewerCellRenderer text;
    private FastAlignmentViewerCellRenderer[] viableRenderers;
    private int cellWidth;
    private int cellHeight;

    protected void calculateViableRenderers(int n) {
        if (n < 6) {
            this.viableRenderers = new FastAlignmentViewerCellRenderer[1];
            this.viableRenderers[0] = this.color;
        } else if (n < 16) {
            this.viableRenderers = new FastAlignmentViewerCellRenderer[2];
            this.viableRenderers[0] = this.color;
            this.viableRenderers[1] = this.border;
        } else {
            this.viableRenderers = new FastAlignmentViewerCellRenderer[3];
            this.viableRenderers[0] = this.color;
            this.viableRenderers[1] = this.border;
            this.viableRenderers[2] = this.text;
        }
    }

    public MultiplexerFastAlignmentViewerCellRenderer(JAlignmentViewer jAlignmentViewer) {
        this.viewer = jAlignmentViewer;
        jAlignmentViewer.addPropertyChangeListener(this);
        this.cellWidth = jAlignmentViewer.getCellWidth();
        this.cellHeight = jAlignmentViewer.getCellHeight();
        this.color = new ColorFastAlignmentViewerCellRenderer();
        this.border = new BorderFastAlignmentViewerCellRenderer();
        this.text = new TextFastAlignmentViewerCellRenderer();
        if (this.cellWidth < this.cellHeight) {
            this.calculateViableRenderers(this.cellWidth);
        } else {
            this.calculateViableRenderers(this.cellHeight);
        }
    }

    public void renderAlignmentViewerCell(Graphics graphics, int n, int n2, int n3, int n4, JAlignmentViewer jAlignmentViewer, Element element, SequenceAlignmentPoint sequenceAlignmentPoint, Color color, boolean bl, boolean bl2, boolean bl3) {
        if (jAlignmentViewer != jAlignmentViewer) {
            throw new IllegalArgumentException("MultiplexerFastAlignmentViewer should only be used for a single JAlignmentViewer");
        }
        int n5 = 0;
        while (n5 < this.viableRenderers.length) {
            this.viableRenderers[n5].renderAlignmentViewerCell(graphics, n, n2, n3, n4, jAlignmentViewer, element, sequenceAlignmentPoint, color, bl, bl2, bl3);
            ++n5;
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("cellHeight") || propertyChangeEvent.getPropertyName().equals("cellWidth")) {
            this.cellHeight = this.viewer.getCellHeight();
            this.cellWidth = this.viewer.getCellWidth();
            this.calculateViableRenderers(Math.min(this.cellWidth, this.cellHeight));
        }
    }
}

