/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.bioinf.gui.viewer;

import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JButton;
import javax.swing.JPanel;
import uk.ac.man.bioinf.sequence.alignment.GappedSequence;
import uk.ac.man.bioinf.sequence.alignment.SequenceAlignment;
import uk.ac.man.bioinf.sequence.alignment.event.AlignmentEvent;
import uk.ac.man.bioinf.sequence.alignment.event.AlignmentEventType;
import uk.ac.man.bioinf.sequence.alignment.event.AlignmentListener;

public class JAlignmentButtonPanel
extends JPanel
implements ItemSelectable,
AlignmentListener {
    private ItemListener itemListener;
    private int prototypicalCellHeight = 15;
    private Map buttonMap = new WeakHashMap();
    private Map colorMap = new WeakHashMap();
    private SequenceAlignment msa;
    private Dimension preferredSize = new Dimension();

    public JAlignmentButtonPanel() {
        this.setLayout(new GridLayout(0, 1));
    }

    public JAlignmentButtonPanel(SequenceAlignment sequenceAlignment) {
        this();
        this.setSequenceAlignment(sequenceAlignment);
    }

    public void setFixedCellHeight(int n) {
        this.prototypicalCellHeight = n;
    }

    public Dimension getPreferredSize() {
        this.preferredSize.setSize(70, this.getComponentCount() * this.prototypicalCellHeight);
        return this.preferredSize;
    }

    public Point getPointForSequence(GappedSequence gappedSequence) {
        return ((JButton)this.buttonMap.get(gappedSequence)).getLocation();
    }

    public void setSequenceColor(GappedSequence gappedSequence, Color color) {
        this.syncToAlignment();
        this.colorMap.put(gappedSequence, color);
        ((JButton)this.buttonMap.get(gappedSequence)).setBackground(color);
        this.repaint();
    }

    public Color getSequenceColor(GappedSequence gappedSequence) {
        return (Color)this.colorMap.get(gappedSequence);
    }

    public void clearSequenceColor(GappedSequence gappedSequence) {
        this.setSequenceColor(gappedSequence, this.getBackground());
    }

    public void clearAllSequenceColors() {
        this.colorMap.clear();
        this.syncToAlignment();
    }

    public void setSequenceAlignment(SequenceAlignment sequenceAlignment) {
        this.msa = sequenceAlignment;
        sequenceAlignment.addAlignmentListener((AlignmentListener)this);
        this.syncToAlignment();
    }

    private void syncToAlignment() {
        this.buttonMap.clear();
        this.removeAll();
        int n = this.msa.getNumberSequences();
        int n2 = 0;
        while (n2 < n) {
            if (n2 >= this.getComponentCount()) {
                this.add(new JButton());
            }
            GappedSequence gappedSequence = this.msa.getSequenceAt(n2 + 1);
            this.setButton(gappedSequence, (JButton)this.getComponent(n2));
            ++n2;
        }
        int n3 = this.getComponentCount();
        while (n3 > n) {
            this.remove(n3);
            --n3;
        }
        this.invalidate();
        this.repaint();
    }

    public void setButton(GappedSequence gappedSequence, JButton jButton) {
        jButton.setFont(jButton.getFont().deriveFont(6.0f));
        Color color = (Color)this.colorMap.get(gappedSequence);
        if (color != null) {
            jButton.setBackground(color);
        }
        jButton.setLabel(gappedSequence.getIdentifier().getTitle());
        jButton.addActionListener(new SequenceButtonListener(gappedSequence));
        this.buttonMap.put(gappedSequence, jButton);
    }

    public void changeOccurred(AlignmentEvent alignmentEvent) {
        if (alignmentEvent.getType() == AlignmentEventType.DELETE || alignmentEvent.getType() == AlignmentEventType.INSERT) {
            this.syncToAlignment();
        }
    }

    public void addItemListener(ItemListener itemListener) {
        if (itemListener == null) {
            return;
        }
        this.itemListener = AWTEventMulticaster.add(this.itemListener, itemListener);
    }

    public void removeItemListener(ItemListener itemListener) {
        if (itemListener == null) {
            return;
        }
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, itemListener);
    }

    public Object[] getSelectedObjects() {
        return null;
    }

    protected void processItemEvent(ItemEvent itemEvent) {
        if (this.itemListener != null) {
            this.itemListener.itemStateChanged(itemEvent);
        }
    }

    class SequenceButtonListener
    implements ActionListener {
        private GappedSequence seq;

        public SequenceButtonListener(GappedSequence gappedSequence) {
            this.seq = gappedSequence;
        }

        public GappedSequence getSequence() {
            return this.seq;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JAlignmentButtonPanel.this.processItemEvent(new ItemEvent(JAlignmentButtonPanel.this, 701, this.seq, 1));
        }
    }
}

