/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.bioinf.gui.util.forms;

import java.awt.Toolkit;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class IntegerField
extends JTextField {
    private Toolkit toolkit = Toolkit.getDefaultToolkit();
    private NumberFormat integerFormatter = NumberFormat.getNumberInstance(Locale.US);

    public IntegerField(int n) {
        super(n);
        this.integerFormatter.setParseIntegerOnly(true);
    }

    public IntegerField(int n, int n2) {
        super(n2);
        this.integerFormatter.setParseIntegerOnly(true);
        this.setValue(n);
    }

    public boolean isValid() {
        try {
            this.integerFormatter.parse(this.getText()).intValue();
        }
        catch (ParseException parseException) {
            return false;
        }
        return true;
    }

    public int getValue() {
        int n = 0;
        try {
            n = this.integerFormatter.parse(this.getText()).intValue();
        }
        catch (ParseException parseException) {
            this.toolkit.beep();
        }
        return n;
    }

    public void setValue(int n) {
        this.setText(this.integerFormatter.format(n));
    }

    protected Document createDefaultModel() {
        return new IntegerDocument();
    }

    protected class IntegerDocument
    extends PlainDocument {
        protected IntegerDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            char[] cArray = string.toCharArray();
            char[] cArray2 = new char[cArray.length];
            int n2 = 0;
            int n3 = 0;
            while (n3 < cArray2.length) {
                if (Character.isDigit(cArray[n3]) || cArray[n3] == '-' || cArray[n3] == '+') {
                    cArray2[n2++] = cArray[n3];
                } else {
                    IntegerField.this.toolkit.beep();
                    System.err.println("insertString: " + cArray[n3]);
                }
                ++n3;
            }
            super.insertString(n, new String(cArray2, 0, n2), attributeSet);
        }
    }
}

