/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.bioinf.gui.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import uk.ac.man.bioinf.util.PackageResourceAdapter;

public class ApplicationFrame
extends JFrame {
    private PackageResourceAdapter ra;
    private String appName;
    private JMenuBar mb;
    private JToolBar tb;
    private JLabel messages;
    private HashMap menuMapping;
    private HashMap menuItemLocation;
    private HashMap menuItemMapping;
    private HashMap buttonMapping;
    private JPanel contentPane;
    private JComponent contents;

    public ApplicationFrame() {
        this((String)null);
    }

    public ApplicationFrame(String string) {
        this.appName = string;
        this.menuMapping = new HashMap();
        this.menuItemMapping = new HashMap();
        this.menuItemLocation = new HashMap();
        this.buttonMapping = new HashMap();
        try {
            this.ra = new PackageResourceAdapter(string);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Couldn't find resource file 'resources.locale.' + resourceName + '.properties.");
        }
        this.setTitle(this.ra.getMessageString(this.appName + ".title"));
        this.initGUI();
    }

    private void initGUI() {
        final ApplicationFrame applicationFrame = this;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                int n = JOptionPane.showConfirmDialog(applicationFrame, ApplicationFrame.this.ra.getMessageString(ApplicationFrame.this.appName + ".quit"), ApplicationFrame.this.ra.getMessageString(ApplicationFrame.this.appName + ".quitTitle"), 0);
                if (n == 0) {
                    System.err.println("Bye.");
                    System.exit(0);
                }
            }
        });
        this.setDefaultCloseOperation(0);
        this.mb = new JMenuBar();
        this.mb.setPreferredSize(new Dimension(200, 20));
        this.setJMenuBar(this.mb);
        this.tb = new JToolBar();
        this.tb.setBorder(BorderFactory.createRaisedBevelBorder());
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new BorderLayout());
        this.contentPane.add((Component)this.tb, "North");
        this.showInitialSplash();
        this.messages = new JLabel(this.ra.getMessageString(this.appName + ".initMessage"));
        this.messages.setBorder(BorderFactory.createLoweredBevelBorder());
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.messages, "Center");
        this.contentPane.add((Component)jPanel, "South");
        this.setContentPane(this.contentPane);
        this.pack();
        this.setVisible(true);
    }

    public JMenu addMenu(String string) {
        String string2 = this.ra.getMessageString(this.appName + ".Menu." + string);
        JMenu jMenu = new JMenu(string2);
        this.menuMapping.put(string, jMenu);
        this.mb.add(jMenu);
        return jMenu;
    }

    public JMenu removeMenu(String string) {
        JMenu jMenu = (JMenu)this.menuMapping.remove(string);
        if (jMenu == null) {
            throw new IllegalArgumentException("Can't find menu with resourceName " + string);
        }
        this.mb.remove(jMenu);
        return jMenu;
    }

    public JMenuItem addMenuItem(String string, String string2) throws IllegalArgumentException {
        String string3 = this.ra.getMessageString(this.appName + ".MenuItem." + string2);
        JMenu jMenu = (JMenu)this.menuMapping.get(string);
        if (jMenu == null) {
            throw new IllegalArgumentException("Can't find menu with resourceName " + string);
        }
        JMenuItem jMenuItem = new JMenuItem(string3);
        this.menuItemMapping.put(string2, jMenuItem);
        jMenu.add(jMenuItem);
        this.menuItemLocation.put(string2, string);
        return jMenuItem;
    }

    public JMenuItem removeMenuItem(String string) throws IllegalArgumentException {
        JMenuItem jMenuItem = (JMenuItem)this.menuItemMapping.remove(string);
        if (jMenuItem == null) {
            throw new IllegalArgumentException("Can't find menu with resourceName " + string);
        }
        String string2 = (String)this.menuItemLocation.remove(string);
        JMenu jMenu = (JMenu)this.menuMapping.get(string2);
        jMenu.remove(jMenuItem);
        return jMenuItem;
    }

    public JMenu addSubMenu(String string, String string2) throws IllegalArgumentException {
        String string3 = this.ra.getMessageString(this.appName + ".Menu." + string2);
        JMenu jMenu = (JMenu)this.menuMapping.get(string);
        if (jMenu == null) {
            throw new IllegalArgumentException("Can't find menu with resourceName " + string);
        }
        JMenu jMenu2 = new JMenu(string3);
        this.menuMapping.put(string2, jMenu2);
        jMenu.add(jMenu2);
        return jMenu2;
    }

    public void setMenuEnabled(String string, boolean bl) throws IllegalArgumentException {
        JMenu jMenu = (JMenu)this.menuMapping.get(string);
        if (jMenu == null) {
            throw new IllegalArgumentException("Can't find menu with resourceName " + string);
        }
        jMenu.setEnabled(bl);
    }

    public void setMenuItemEnabled(String string, boolean bl) throws IllegalArgumentException {
        JMenu jMenu = (JMenu)this.menuItemMapping.get(string);
        if (jMenu == null) {
            throw new IllegalArgumentException("Can't find menuitem with resourceName " + string);
        }
        jMenu.setEnabled(bl);
    }

    public JButton addButton(String string) throws IllegalArgumentException {
        String string2 = this.ra.getMessageString(this.appName + ".Button." + string);
        JButton jButton = new JButton(string2);
        this.buttonMapping.put(string, jButton);
        this.tb.add(jButton);
        this.tb.invalidate();
        return jButton;
    }

    public JButton addButton(String string, String string2) throws IllegalArgumentException {
        String string3 = this.ra.getMessageString(this.appName + ".Button." + string);
        ImageIcon imageIcon = new ImageIcon(this.ra.getImageURL(this.appName + ".Button." + string2));
        JButton jButton = new JButton(string3, imageIcon);
        this.buttonMapping.put(string, jButton);
        this.tb.add(jButton);
        this.tb.invalidate();
        return jButton;
    }

    public JButton addButton(String string, String string2, String string3) throws IllegalArgumentException {
        String string4 = this.ra.getMessageString(this.appName + ".Button." + string);
        ImageIcon imageIcon = new ImageIcon(this.ra.getImageURL(this.appName + ".Button." + string2));
        JButton jButton = new JButton(string4, imageIcon);
        jButton.setToolTipText(this.ra.getToolTip(this.appName + ".Button." + string2));
        this.buttonMapping.put(string, jButton);
        this.tb.add(jButton);
        this.tb.invalidate();
        return jButton;
    }

    public JToggleButton addToggleButton(String string) throws IllegalArgumentException {
        String string2 = this.ra.getMessageString(this.appName + ".Button." + string);
        JToggleButton jToggleButton = new JToggleButton(string2);
        this.buttonMapping.put(string, jToggleButton);
        this.tb.add(jToggleButton);
        this.tb.invalidate();
        return jToggleButton;
    }

    public JToggleButton addToggleButton(String string, String string2) throws IllegalArgumentException {
        String string3 = this.ra.getMessageString(this.appName + ".Button." + string);
        ImageIcon imageIcon = new ImageIcon(this.ra.getImageURL(this.appName + ".Button." + string2));
        JToggleButton jToggleButton = new JToggleButton(string3, imageIcon);
        this.buttonMapping.put(string, jToggleButton);
        this.tb.add(jToggleButton);
        this.tb.invalidate();
        return jToggleButton;
    }

    public JToggleButton addToggleButton(String string, String string2, String string3) throws IllegalArgumentException {
        String string4 = this.ra.getMessageString(this.appName + ".Button." + string);
        ImageIcon imageIcon = new ImageIcon(this.ra.getImageURL(this.appName + ".Button." + string2));
        JToggleButton jToggleButton = new JToggleButton(string4, imageIcon);
        jToggleButton.setToolTipText(this.ra.getToolTip(this.appName + ".Button." + string2));
        this.buttonMapping.put(string, jToggleButton);
        this.tb.add(jToggleButton);
        this.tb.invalidate();
        return jToggleButton;
    }

    public JButton removeButton(String string) throws IllegalArgumentException {
        JButton jButton = (JButton)this.buttonMapping.remove(string);
        if (jButton == null) {
            throw new IllegalArgumentException("Can't find menu with resourceName " + string);
        }
        this.tb.remove(jButton);
        return jButton;
    }

    public void showInitialSplash() {
        URL uRL = this.ra.getHelpURL(this.appName + ".initialSplash");
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setEditable(false);
        try {
            jEditorPane.setPage(uRL);
            jEditorPane.setPreferredSize(new Dimension(200, 100));
        }
        catch (IOException iOException) {
            System.err.println("Couldn't find initial splash page.\n" + iOException.getMessage());
        }
        this.setContents(jEditorPane);
    }

    public PackageResourceAdapter getResourceAdapter() {
        return this.ra;
    }

    public void setContents(JComponent jComponent) {
        if (this.contents != null) {
            this.contentPane.remove(this.contents);
        }
        this.contentPane.add((Component)jComponent, "Center");
        this.contents = jComponent;
        this.contentPane.revalidate();
        this.contentPane.repaint();
    }

    public JComponent getContents() {
        return this.contents;
    }

    public void showMessage(String string) {
        this.messages.setText(string);
    }
}

