/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.bioinf.gui.optionable;

import java.awt.Dimension;
import java.awt.Point;
import java.util.HashMap;
import javax.swing.JFrame;
import uk.ac.man.bioinf.apps.optionable.NullOptionHandler;
import uk.ac.man.bioinf.apps.optionable.OptionHandler;
import uk.ac.man.bioinf.apps.optionable.Optionable;
import uk.ac.man.bioinf.apps.optionable.OptionableStateException;

public abstract class OptionableJFrame
extends JFrame
implements Optionable {
    private String optionableName;
    private OptionHandler optionHandler;
    private boolean sizeSetAsOption = false;
    private boolean locationSetAsOption = false;
    private boolean haveOptioned = false;
    private static OptionHandler defaultOptionHandler;

    public OptionableJFrame(String string) {
        this(string, "");
    }

    public OptionableJFrame(String string, String string2) {
        this(string, string2, false);
    }

    public OptionableJFrame(String string, boolean bl) {
        this(string, "", bl);
    }

    public OptionableJFrame(String string, String string2, boolean bl) {
        this(string, string2, bl, null);
    }

    public OptionableJFrame(String string, String string2, boolean bl, OptionHandler optionHandler) {
        super(string2);
        this.optionableName = string;
        this.optionHandler = this.optionHandler;
        if (!bl) {
            this.forceOptionable();
        }
    }

    public void setOptions() throws OptionableStateException {
        if (this.haveOptioned) {
            throw new OptionableStateException("Have already set the optionable status of this frame");
        }
        this.forceOptionable();
    }

    protected void forceOptionable() {
        if (this.haveOptioned) {
            throw new RuntimeException("Have already set the optionable status of this frame");
        }
        this.getOptionHandler().addOptionable((Optionable)this);
        this.haveOptioned = true;
    }

    public void setDefaultSize(int n, int n2) {
        if (!this.sizeSetAsOption) {
            super.setSize(n, n2);
        }
    }

    public void setDefaultLocation(int n, int n2) {
        if (!this.locationSetAsOption) {
            super.setLocation(n, n2);
        }
    }

    public void defaultPack() {
        if (!this.locationSetAsOption) {
            super.pack();
        }
    }

    public Object getOptions() {
        HashMap<String, Cloneable> hashMap = new HashMap<String, Cloneable>();
        hashMap.put("frameSize", this.getSize());
        hashMap.put("frameLocation", this.getLocation());
        return hashMap;
    }

    public void setOptions(Object object) {
        try {
            if (object == null) {
                return;
            }
            HashMap hashMap = (HashMap)object;
            this.setSize(new Dimension(300, 300));
            this.setSize((Dimension)hashMap.get("frameSize"));
            this.sizeSetAsOption = true;
            this.setLocation((Point)hashMap.get("frameLocation"));
            this.locationSetAsOption = true;
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public void setOptionHandler(OptionHandler optionHandler) {
        this.optionHandler = optionHandler;
    }

    public OptionHandler getOptionHandler() {
        if (this.optionHandler == null) {
            return OptionableJFrame.getDefaultOptionHandler();
        }
        return this.optionHandler;
    }

    public String getOptionGroupName() {
        return this.optionableName;
    }

    public static void setDefaultOptionHandler(OptionHandler optionHandler) {
        defaultOptionHandler = optionHandler;
    }

    public static OptionHandler getDefaultOptionHandler() {
        if (defaultOptionHandler == null) {
            return NullOptionHandler.getInstance();
        }
        return defaultOptionHandler;
    }
}

