/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.bioinf.gui.color;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import uk.ac.man.bioinf.apps.invoker.AnonInvoker;
import uk.ac.man.bioinf.apps.invoker.InvokerInternalQueue;
import uk.ac.man.bioinf.gui.color.ColorMap;
import uk.ac.man.bioinf.gui.color.ThreadableColorMap;
import uk.ac.man.bioinf.gui.viewer.JAlignmentViewer;
import uk.ac.man.bioinf.sequence.Element;
import uk.ac.man.bioinf.sequence.alignment.SequenceAlignment;
import uk.ac.man.bioinf.sequence.alignment.event.AlignmentEvent;
import uk.ac.man.bioinf.sequence.alignment.event.AlignmentListener;
import uk.ac.man.bioinf.sequence.event.SequenceEvent;
import uk.ac.man.bioinf.sequence.event.SequenceListener;
import uk.ac.man.bioinf.sequence.geom.SequenceAlignmentPoint;

public class ThreadedColorMap
implements ColorMap,
SequenceListener,
AlignmentListener,
PropertyChangeListener {
    public static final String NAME = "Threaded Color Map";
    private InvokerInternalQueue queue;
    private SequenceAlignment alignment;
    private ThreadableColorMap map;
    private JAlignmentViewer viewer;

    public ThreadedColorMap(JAlignmentViewer jAlignmentViewer, SequenceAlignment sequenceAlignment, ThreadableColorMap threadableColorMap) {
        this(jAlignmentViewer, sequenceAlignment, threadableColorMap, new InvokerInternalQueue());
    }

    public ThreadedColorMap(JAlignmentViewer jAlignmentViewer, SequenceAlignment sequenceAlignment, ThreadableColorMap threadableColorMap, InvokerInternalQueue invokerInternalQueue) {
        this.alignment = sequenceAlignment;
        this.queue = invokerInternalQueue;
        this.map = threadableColorMap;
        this.viewer = jAlignmentViewer;
        jAlignmentViewer.addPropertyChangeListener(this);
        sequenceAlignment.addAlignmentListener((AlignmentListener)this);
        sequenceAlignment.addSequenceListener((SequenceListener)this);
    }

    public Color getColorAt(SequenceAlignment sequenceAlignment, Element element, SequenceAlignmentPoint sequenceAlignmentPoint) {
        return this.map.getColorAt(sequenceAlignment, element, sequenceAlignmentPoint);
    }

    protected void validate() {
        this.queue.makeEmpty();
        this.queue.enqueue(new AnonInvoker(){
            long start;

            public Object slow() {
                ThreadedColorMap.this.map.calculate();
                return null;
            }

            public void doRun() {
                ThreadedColorMap.this.viewer.repaint();
            }
        });
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("colorMap") && propertyChangeEvent.getSource() == this.viewer && propertyChangeEvent.getOldValue() == this) {
            this.destroy();
        }
    }

    public void changeOccurred(SequenceEvent sequenceEvent) {
        this.validate();
    }

    public void changeOccurred(AlignmentEvent alignmentEvent) {
        this.validate();
    }

    public String getName() {
        return NAME;
    }

    public String getInternalThreadedColorMap() {
        return this.map.getName();
    }

    public void destroy() {
        this.queue.destroy();
        this.queue = null;
        this.alignment.removeSequenceListener((SequenceListener)this);
        this.alignment.removeAlignmentListener((AlignmentListener)this);
    }
}

