/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.bioinf.gui.color;

import java.awt.Color;
import uk.ac.man.bioinf.analysis.misc.PercentageIDCalculator;
import uk.ac.man.bioinf.gui.color.ColorList;
import uk.ac.man.bioinf.gui.color.ThreadableColorMap;
import uk.ac.man.bioinf.sequence.Element;
import uk.ac.man.bioinf.sequence.alignment.Gap;
import uk.ac.man.bioinf.sequence.alignment.SequenceAlignment;
import uk.ac.man.bioinf.sequence.geom.SequenceAlignmentPoint;

public class PercentIDVarianceColorMap
implements ThreadableColorMap {
    public static final String NAME = "Percentage ID variance Color Map";
    private ColorList colors;
    private PercentageIDCalculator calculator;
    private int[] colorAtColumn;

    public PercentIDVarianceColorMap(PercentageIDCalculator percentageIDCalculator) {
        this(percentageIDCalculator, ColorList.getHotToColdColorList());
    }

    public PercentIDVarianceColorMap(PercentageIDCalculator percentageIDCalculator, ColorList colorList) {
        this.calculator = percentageIDCalculator;
        this.colors = colorList;
        this.calculate();
    }

    public Color getColorAt(SequenceAlignment sequenceAlignment, Element element, SequenceAlignmentPoint sequenceAlignmentPoint) {
        if (element == null || element == Gap.GAP) {
            return null;
        }
        try {
            return this.colors.getColorAt(this.colorAtColumn[sequenceAlignmentPoint.getX() - 1]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println("Iob exception at col " + sequenceAlignmentPoint.getX());
            return null;
        }
    }

    public String getName() {
        return NAME;
    }

    public void calculate() {
        double[] dArray = this.calculator.getVariance();
        int[] nArray = new int[dArray.length];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = (int)(dArray[n] * (double)(this.colors.length() - 1));
            ++n;
        }
        this.colorAtColumn = nArray;
    }
}

