/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.bioinf.sequence.group;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import uk.ac.man.bioinf.sequence.Sequence;
import uk.ac.man.bioinf.sequence.alignment.GappedSequence;
import uk.ac.man.bioinf.sequence.group.AbstractGappedSequenceGroup;

public class DefaultGappedSequenceGroup
extends AbstractGappedSequenceGroup {
    private List sequences = new ArrayList();
    private GappedSequence[] cache;
    private boolean cacheOutOfDate = true;

    public void addSequenceToGroup(Sequence sequence) {
        this.cacheOutOfDate = true;
        this.sequences.add(sequence);
    }

    public void removeSequenceFromGroup(Sequence sequence) {
        this.cacheOutOfDate = true;
        this.sequences.remove(sequence);
    }

    public boolean containsSequence(Sequence sequence) {
        return this.sequences.contains(sequence);
    }

    public Sequence[] getSequences() {
        if (this.cacheOutOfDate) {
            Object[] objectArray = this.sequences.toArray();
            this.cache = new GappedSequence[objectArray.length];
            System.arraycopy(objectArray, 0, this.cache, 0, this.cache.length);
        }
        return this.cache;
    }

    public void clearSequences() {
        this.cacheOutOfDate = true;
        this.sequences.clear();
    }

    public int getNumberSequences() {
        return this.sequences.size();
    }

    public Sequence getSequenceAt(int n) {
        return (Sequence)this.sequences.get(n);
    }

    public GappedSequence getGappedSequenceAt(int n) {
        return (GappedSequence)this.sequences.get(n);
    }

    public Iterator iterator() {
        return this.sequences.iterator();
    }
}

