/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.bioinf.sequence.complex;

import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import uk.ac.man.bioinf.sequence.Residue;
import uk.ac.man.bioinf.sequence.complex.ComplexElement;
import uk.ac.man.bioinf.sequence.complex.ComplexElementFactoryInterface;
import uk.ac.man.bioinf.sequence.complex.DefaultComplexElement;
import uk.ac.man.bioinf.sequence.complex.Modification;
import uk.ac.man.bioinf.util.ArrayManipulation;

class WeakComplexElementFactory
implements ComplexElementFactoryInterface {
    private DefaultComplexElement cachedElement;
    private WeakHashMap complexElements = new WeakHashMap();

    WeakComplexElementFactory() {
    }

    public ComplexElement getComplexElement(Residue residue) {
        if (this.cachedElement == null) {
            this.cachedElement = new DefaultComplexElement();
        }
        this.cachedElement.setResidue(residue);
        this.cachedElement.setModifications();
        return this.getCachedComplexElement();
    }

    public ComplexElement addComplexElement(Residue residue, Modification modification) {
        if (this.cachedElement == null) {
            this.cachedElement = new DefaultComplexElement();
        }
        this.cachedElement.setResidue(residue);
        this.cachedElement.setModifications(modification);
        return this.getCachedComplexElement();
    }

    public ComplexElement addComplexElement(ComplexElement complexElement, Modification modification) {
        if (this.cachedElement == null) {
            this.cachedElement = new DefaultComplexElement();
        }
        this.cachedElement.setResidue(complexElement.getResidue());
        this.cachedElement.setModifications(complexElement.getModifications(), modification);
        return this.getCachedComplexElement();
    }

    public ComplexElement removeComplexElement(ComplexElement complexElement, Modification modification) {
        if (this.cachedElement == null) {
            this.cachedElement = new DefaultComplexElement();
        }
        Object[] objectArray = complexElement.getModifications();
        Object[] objectArray2 = new Modification[objectArray.length - 1];
        ArrayManipulation.removeFromArray((Object[])objectArray, (Object[])objectArray2, (Object)modification);
        this.cachedElement.setResidue(complexElement.getResidue());
        this.cachedElement.setModifications((Modification[])objectArray2);
        return this.getCachedComplexElement();
    }

    private ComplexElement getCachedComplexElement() {
        Object object;
        Object v = this.complexElements.get(this.cachedElement);
        if (v != null && (object = ((WeakReference)v).get()) != null) {
            return (ComplexElement)object;
        }
        this.complexElements.put(this.cachedElement, new WeakReference<DefaultComplexElement>(this.cachedElement));
        object = this.cachedElement;
        this.cachedElement = null;
        return object;
    }
}

