/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.bioinf.sequence.complex;

import java.util.HashMap;
import uk.ac.man.bioinf.sequence.complex.GenericModification;
import uk.ac.man.bioinf.sequence.complex.IllegalDuplicateModificationException;
import uk.ac.man.bioinf.sequence.complex.Modification;
import uk.ac.man.bioinf.sequence.complex.NoSuchModificationException;
import uk.ac.man.bioinf.sequence.complex.SingletonModification;

public class ModificationFactory {
    private static HashMap modifications = new HashMap();

    static void addNewSingletonModification(String string, SingletonModification singletonModification) {
        if (modifications.containsKey(string)) {
            throw new IllegalDuplicateModificationException("Attempt to install singleton modification " + singletonModification.getName() + " conflicts with modification " + modifications.get(string));
        }
        modifications.put(string, singletonModification);
    }

    static void addNewGenericModification(String string, GenericModification genericModification) {
        if (modifications.containsKey(string)) {
            throw new IllegalDuplicateModificationException("Attempt to generic singleton modification " + genericModification.getName() + " conflicts with modification " + modifications.get(string));
        }
        modifications.put(string, genericModification);
    }

    public static Modification getModification(String string) {
        Object v = modifications.get(string);
        if (v == null) {
            throw new NoSuchModificationException("Attempt to recover modification of name " + string + " which does not exist. " + "Use the ModificationFactory.createModification instead");
        }
        return (Modification)v;
    }

    public static Modification createModification(String string, char c) {
        GenericModification genericModification = new GenericModification(string, c);
        ModificationFactory.addNewGenericModification(string, genericModification);
        return genericModification;
    }
}

